/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import se.hirt.greychart.providers.SampleCountingBuffer;

public class IntegratingSampleCountingBuffer
extends SampleCountingBuffer {
    public IntegratingSampleCountingBuffer(int size) {
        super(size);
    }

    public void addDataPoint(double normalizedStartX, double normalizedEndX, double value) {
        if (normalizedStartX < 0.0 || normalizedStartX > 1.0) {
            throw new IllegalArgumentException("Must add a normalized value [0, 1]! Value was " + normalizedStartX);
        }
        if (normalizedEndX < 0.0 || normalizedEndX > 1.0) {
            throw new IllegalArgumentException("Must add a normalized value [0, 1]! Value was " + normalizedEndX);
        }
        this.addSamplePoint((double)this.samples.length * normalizedStartX, value);
        this.addSamplePoint(Math.max((double)this.samples.length * normalizedEndX, (double)this.samples.length * normalizedStartX + 1.0), -value);
    }

    protected void addSamplePoint(double currentX, double currentY) {
        int currentIndex = this.getIndex(currentX);
        if (currentIndex >= 0 && currentIndex < this.samples.length) {
            ++this.samples[currentIndex].count;
            this.samples[currentIndex].y += currentY;
            this.samples[currentIndex].sampled = true;
            ++this.m_count;
        }
    }

    public void fixSamples() {
        double currentY = 0.0;
        int n = 0;
        while (n < this.samples.length) {
            this.samples[n].y += currentY;
            currentY = this.samples[n].y;
            if (this.samples[n].y > 0.0) {
                this.samples[n].sampled = true;
            }
            ++n;
        }
        if (!this.samples[this.samples.length - 1].sampled && currentY > 0.0) {
            this.samples[this.samples.length - 1].y = currentY;
            this.samples[this.samples.length - 1].sampled = true;
        }
    }

    protected void calcStatistics() {
        int n = 0;
        while (n < this.samples.length) {
            if (this.samples[n].hasSample()) {
                if (this.m_logarithmic && this.samples[n].y != 0.0) {
                    this.samples[n].y = Math.log(this.samples[n].y + 3.0);
                }
                if (Double.isNaN(this.m_maxY)) {
                    this.m_maxY = this.samples[n].y;
                    this.m_minY = this.samples[n].y;
                }
                this.m_maxY = Math.max(this.samples[n].y, this.m_maxY);
                this.m_minY = Math.min(this.samples[n].y, this.m_minY);
                this.m_sampleCount = (int)((long)this.m_sampleCount + this.samples[n].count);
            }
            ++n;
        }
    }
}

