/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import java.awt.Polygon;
import java.util.Iterator;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.impl.LongWorldToDeviceConverter;
import se.hirt.greychart.impl.OptimizingProvider;
import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.impl.WorldToDeviceConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeOptimizingProvider
implements OptimizingProvider {
    private final OptimizingProvider[] providers;

    public CompositeOptimizingProvider(OptimizingProvider[] providers) {
        this.providers = providers;
    }

    @Override
    public void dispose() {
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.dispose();
            ++n2;
        }
    }

    @Override
    public void setDataChanged(boolean changed) {
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.setDataChanged(changed);
            ++n2;
        }
    }

    @Override
    public void abort() {
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.abort();
            ++n2;
        }
    }

    @Override
    public boolean hasDataChanged() {
        return false;
    }

    @Override
    public Iterator<SamplePoint> getSamples(int width) {
        throw new UnsupportedOperationException("Ajjabajja!");
    }

    @Override
    public Polygon getSamplesPolygon(LongWorldToDeviceConverter xWorldToDevice, WorldToDeviceConverter yWorldToDevice) {
        throw new UnsupportedOperationException("Ajjabajja!");
    }

    @Override
    public void setResolution(int resolution) {
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.setResolution(resolution);
            ++n2;
        }
    }

    @Override
    public boolean update() {
        boolean update = false;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            if (provider.update()) {
                update = true;
            }
            ++n2;
        }
        return update;
    }

    @Override
    public OptimizingProvider[] getChildren() {
        return this.providers;
    }

    @Override
    public DataSeries getDataSeries() {
        throw new UnsupportedOperationException("apa");
    }

    @Override
    public long getMaxX() {
        long max = Long.MIN_VALUE;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            max = Math.max(provider.getMaxX(), max);
            ++n2;
        }
        return max;
    }

    @Override
    public double getMaxY() {
        double max = Double.NEGATIVE_INFINITY;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            max = Math.max(provider.getMaxY(), max);
            ++n2;
        }
        return max;
    }

    @Override
    public double getMinY() {
        double min = Double.POSITIVE_INFINITY;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            min = Math.min(provider.getMinY(), min);
            ++n2;
        }
        return min;
    }

    @Override
    public long getMinX() {
        long min = Long.MAX_VALUE;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            min = Math.min(provider.getMinX(), min);
            ++n2;
        }
        return min;
    }

    @Override
    public void setRange(long start, long end) {
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.setRange(start, end);
            ++n2;
        }
    }

    @Override
    public long getValueCount() {
        long count = 0L;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            count += provider.getValueCount();
            ++n2;
        }
        return count;
    }

    @Override
    public void setIntegrate(boolean integrate) {
    }
}

