/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.providers.AbstractSampler;
import se.hirt.greychart.util.ChartRenderingToolkit;

public final class AveragingSampleBuffer
extends AbstractSampler {
    private double previousX = Double.NaN;
    private double previousY = Double.NaN;
    private boolean m_lastBucketsFilled = false;

    public AveragingSampleBuffer(int size) {
        super(size);
        this.samples = new SamplePoint[size + 1];
        int i = 0;
        while (i < size + 1) {
            this.samples[i] = new SamplePoint();
            this.samples[i].x = i;
            this.samples[i].sampled = false;
            ++i;
        }
    }

    public void reset() {
        int i = 0;
        while (i < this.samples.length) {
            this.samples[i].y = 0.0;
            this.samples[i].count = 0L;
            this.samples[i].sampled = false;
            this.samples[i].min = Double.POSITIVE_INFINITY;
            this.samples[i].max = Double.NEGATIVE_INFINITY;
            this.samples[i].x = i;
            ++i;
        }
        this.previousX = Double.NaN;
        this.previousY = Double.NaN;
        this.m_minY = Double.NaN;
        this.m_maxY = Double.NaN;
        this.m_count = 0L;
        this.m_sampleCount = -1;
        this.m_lastBucketsFilled = false;
    }

    public void addDataPoint(double normalizedX, double currentY) {
        if (normalizedX < 0.0 || normalizedX > 1.0) {
            throw new IllegalArgumentException("Must add a normalized value [0, 1]! Value was " + normalizedX);
        }
        this.addSamplePoint((double)(this.samples.length - 1) * normalizedX, currentY);
    }

    private void fillLastBuckets(int foundSamples) {
        int currentIndex = this.getIndex(this.previousX);
        if (foundSamples > 0) {
            this.fillBucket(currentIndex, this.previousX);
        }
        if (foundSamples > 1) {
            this.fillBucket(currentIndex + 1, currentIndex + 1);
        }
    }

    private void fillBucket(int currentIndex, double startX) {
        if (currentIndex >= 0 && currentIndex < this.samples.length) {
            this.samples[currentIndex].sampled = true;
            this.addSubBucketSample(currentIndex, startX, this.previousY, currentIndex + 1, this.previousY);
        }
    }

    protected void addSamplePoint(double currentX, double currentY) {
        int currentIndex = this.getIndex(currentX);
        if (currentIndex >= 0 && currentIndex < this.samples.length) {
            ++this.samples[currentIndex].count;
            if (this.m_count > 0L) {
                this.addBucketSample(currentX, currentY, this.previousX, this.previousY);
            } else {
                this.addBucketSample(currentX, currentY, currentIndex, currentY);
            }
            ++this.m_count;
        }
        this.previousX = currentX;
        this.previousY = currentY;
    }

    private void addBucketSample(double currentX, double currentY, double previousX, double previousY) {
        if (this.spanMultipleBuckets(previousX, currentX)) {
            this.addSpanningBucketSample(previousX, previousY, currentX, currentY);
        } else {
            this.addSubBucketSample(this.getIndex(currentX), previousX, previousY, currentX, currentY);
        }
    }

    private void addSpanningBucketSample(double x1, double y1, double x2, double y2) {
        int firstXBucketIndex = this.getIndex(x1);
        double firstBucketY = this.getInterpolatedValue(firstXBucketIndex + 1, x1, y1, x2, y2);
        int lastXBucketIndex = this.getIndex(x2);
        double lastBucketY = this.getInterpolatedValue(lastXBucketIndex, x1, y1, x2, y2);
        this.addSubBucketSample(firstXBucketIndex, x1, y1, firstXBucketIndex + 1, firstBucketY);
        this.fillSpanningBuckets(firstXBucketIndex + 1, firstBucketY, lastXBucketIndex, lastBucketY);
        this.addSubBucketSample(lastXBucketIndex, lastXBucketIndex, lastBucketY, x2, y2);
    }

    private void addSubBucketSample(int bucketIndex, double x1, double y1, double x2, double y2) {
        if (this.isValidBucket(bucketIndex)) {
            SamplePoint samplePoint = this.samples[bucketIndex];
            samplePoint.y += (x2 - x1) * (y2 + y1) / 2.0;
            samplePoint.min = Math.min(samplePoint.min, samplePoint.y);
            samplePoint.max = Math.max(samplePoint.max, samplePoint.y);
            samplePoint.sampled = true;
        }
    }

    private void fillSpanningBuckets(int firstBucket, double firstBucketY, int lastBucket, double lastBucketY) {
        int firstIndex;
        int lastIndex = Math.min(lastBucket, this.samples.length);
        int i = firstIndex = Math.max(firstBucket, 0);
        while (i < lastIndex) {
            this.samples[i].y = this.getInterpolatedValue((double)i + 0.5, firstBucket, firstBucketY, lastBucket, lastBucketY);
            double y1 = this.getInterpolatedValue(i, firstBucket, firstBucketY, lastBucket, lastBucketY);
            double y2 = this.getInterpolatedValue(i + 1, firstBucket, firstBucketY, lastBucket, lastBucketY);
            this.samples[i].max = Math.max(y1, y2);
            this.samples[i].min = Math.min(y1, y2);
            this.samples[i].sampled = true;
            ++i;
        }
    }

    private boolean isValidBucket(int bucketIndex) {
        return bucketIndex >= 0 && bucketIndex < this.samples.length;
    }

    private boolean spanMultipleBuckets(double previousX, double currentX) {
        return ChartRenderingToolkit.fastFloor(previousX) != ChartRenderingToolkit.fastFloor(currentX);
    }

    private double getInterpolatedValue(double x, double startX, double startY, double endX, double endY) {
        double k = (endY - startY) / (endX - startX);
        return k * (x - startX) + startY;
    }

    private void fillLastBuckets() {
        if (!this.m_lastBucketsFilled) {
            this.fillLastBuckets((int)this.m_count);
            this.m_lastBucketsFilled = true;
        }
    }

    public SamplePoint[] getSamples() {
        this.fillLastBuckets();
        this.samples[this.samples.length - 1].sampled = false;
        return this.samples;
    }

    public int getSize() {
        return this.samples.length - 1;
    }

    protected void calcStatistics() {
        this.fillLastBuckets();
        int n = 0;
        while (n < this.samples.length - 1) {
            if (this.samples[n].hasSample()) {
                if (this.m_logarithmic && this.samples[n].y != 0.0) {
                    this.samples[n].y = Math.log(this.samples[n].y + 3.0);
                }
                if (Double.isNaN(this.m_maxY)) {
                    this.m_maxY = this.samples[n].y;
                    this.m_minY = this.samples[n].y;
                }
                this.m_maxY = Math.max(this.samples[n].y, this.m_maxY);
                this.m_minY = Math.min(this.samples[n].y, this.m_minY);
                this.m_sampleCount = (int)((long)this.m_sampleCount + this.samples[n].count);
            }
            ++n;
        }
    }
}

