/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.hirt.greychart.XAxis;
import se.hirt.greychart.data.DataChangeEvent;
import se.hirt.greychart.data.DataChangeListener;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.IXYData;
import se.hirt.greychart.impl.LongWorldToDeviceConverter;
import se.hirt.greychart.impl.OptimizingProvider;
import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.impl.WorldToDeviceConverter;
import se.hirt.greychart.providers.AveragingSampleBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AveragingProvider
implements OptimizingProvider {
    private static final Logger LOGGER = Logger.getLogger("se.hirt.greychart");
    private final DataSeries<IXYData> m_dataSeries;
    private final XAxis m_xAxis;
    private AveragingSampleBuffer m_sampleBuffer = new AveragingSampleBuffer(0);
    private AveragingSampleBuffer m_subSamplingBuffer = new AveragingSampleBuffer(0);
    private List m_samplesList = new LinkedList();
    private int m_lastWidth = -1;
    private int m_lastSubSampleWidth = -1;
    private long m_startX;
    private long m_endX;
    private int m_requestedResolution = 0;
    private long m_requestedStartX = Long.MIN_VALUE;
    private long m_requestedEndX = Long.MAX_VALUE;
    private volatile boolean dataChangeOccured = false;
    private boolean m_abort = false;

    public AveragingProvider(DataSeries<IXYData> s, XAxis xAxis) {
        this.m_dataSeries = s;
        this.m_xAxis = xAxis;
        s.addChangeListener(new DataChangeListener(){

            public void onDataChange(DataChangeEvent event) {
                AveragingProvider.this.dataChangeOccured = true;
            }
        });
    }

    @Override
    public void dispose() {
        this.m_sampleBuffer = null;
    }

    @Override
    public boolean update() {
        if (this.isScheduleResample()) {
            this.scheduleResample(4 * this.m_requestedResolution);
            this.dataChangeOccured = false;
            return true;
        }
        return false;
    }

    private boolean isScheduleResample() {
        return this.hasRangeChanged() || this.hasDataChanged() || this.isSampleBufferInvalid();
    }

    private boolean hasRangeChanged() {
        return this.m_startX != this.m_requestedStartX || this.m_endX != this.m_requestedEndX;
    }

    @Override
    public void setDataChanged(boolean changed) {
        this.dataChangeOccured = changed;
    }

    @Override
    public void abort() {
        this.m_abort = true;
    }

    @Override
    public boolean hasDataChanged() {
        return this.dataChangeOccured;
    }

    private boolean isSampleBufferInvalid() {
        return this.m_sampleBuffer == null || this.m_sampleBuffer.getSize() < this.m_requestedResolution * 2;
    }

    @Override
    public void setResolution(int resolution) {
        this.m_requestedResolution = resolution;
    }

    private void scheduleResample(int resolution) {
        this.m_sampleBuffer = this.createSampleBuffer(resolution);
        this.m_samplesList.clear();
        this.m_startX = this.m_requestedStartX;
        this.m_endX = this.m_requestedEndX;
    }

    @Override
    public Iterator<SamplePoint> getSamples(int width) {
        if (width != this.m_lastSubSampleWidth || this.hasDataChanged() || this.hasRangeChanged() || this.m_samplesList.isEmpty()) {
            this.m_samplesList = this.createSubSampleList(width);
            this.m_lastSubSampleWidth = width;
        }
        return this.m_samplesList.iterator();
    }

    @Override
    public Polygon getSamplesPolygon(LongWorldToDeviceConverter xWorldToDevice, WorldToDeviceConverter yWorldToDevice) {
        int deviceWidth = xWorldToDevice.getDeviceWidth();
        int[] xs = new int[deviceWidth + 3];
        int[] ys = new int[deviceWidth + 3];
        int index = 0;
        if (yWorldToDevice.canCalculateDeviceCoordinate()) {
            Iterator<SamplePoint> it = this.getSamples(deviceWidth);
            while (it.hasNext() && index < deviceWidth) {
                SamplePoint sp = it.next();
                xs[index] = sp.x;
                ys[index] = yWorldToDevice.getDeviceCoordinate(sp.y);
                ++index;
            }
        }
        return new Polygon(xs, ys, index);
    }

    private List createSubSampleList(int width) {
        this.m_subSamplingBuffer = this.createSubSampledBuffer(width);
        SamplePoint[] points = this.m_subSamplingBuffer.getSamples();
        ArrayList<SamplePoint> list = new ArrayList<SamplePoint>(this.m_subSamplingBuffer.getSize());
        int n = 0;
        while (n < this.m_subSamplingBuffer.getSize()) {
            if (points[n].hasSample()) {
                list.add(points[n]);
            }
            ++n;
        }
        return list;
    }

    private AveragingSampleBuffer createSampleBuffer(int width) {
        AveragingSampleBuffer sampleBuffer = null;
        if (this.m_lastWidth == width) {
            sampleBuffer = this.m_sampleBuffer;
            sampleBuffer.reset();
        } else {
            sampleBuffer = new AveragingSampleBuffer(width);
            this.m_lastWidth = width;
        }
        long worldWidth = this.m_xAxis.getMax().longValue() - this.m_xAxis.getMin().longValue();
        long leftEdge = this.m_xAxis.getMin().longValue();
        Iterator<IXYData> it = this.m_dataSeries.createIterator(this.m_requestedStartX, this.m_requestedEndX);
        if (!it.hasNext()) {
            return sampleBuffer;
        }
        IXYData data = this.addFirstBoundaryPoint(sampleBuffer, it, worldWidth, leftEdge);
        long x = this.getXAsLong(data);
        long oldx = this.getXAsLong(data);
        if (x >= leftEdge && x <= leftEdge + worldWidth) {
            this.addXYDataPoint(sampleBuffer, worldWidth, leftEdge, data);
        }
        while (it.hasNext() && x < leftEdge + worldWidth && !this.m_abort) {
            IXYData newData = it.next();
            x = this.getXAsLong(newData);
            if (x < oldx) {
                LOGGER.log(Level.WARNING, "Data points out of order: " + x + " is lower than " + oldx);
            } else if (x >= leftEdge + worldWidth) {
                this.addInterpolatedNormalizedPoint(sampleBuffer, 1.0, data, newData, worldWidth, leftEdge);
            } else {
                this.addXYDataPoint(sampleBuffer, worldWidth, leftEdge, newData);
                oldx = x;
            }
            data = newData;
        }
        this.m_abort = false;
        return sampleBuffer;
    }

    private long getXAsLong(IXYData data) {
        return ((Number)data.getX()).longValue();
    }

    /*
     * Unable to fully structure code
     */
    private IXYData addFirstBoundaryPoint(AveragingSampleBuffer sampleBuffer, Iterator<IXYData> it, long worldWidth, long leftEdge) {
        firstDataPoint = null;
        if (!it.hasNext() || (x = this.getXAsLong(firstDataPoint = it.next())) < leftEdge) ** GOTO lbl12
        return firstDataPoint;
lbl-1000:
        // 1 sources

        {
            data = it.next();
            x = this.getXAsLong(data);
            if (x >= leftEdge) {
                this.addInterpolatedNormalizedPoint(sampleBuffer, 0.0, firstDataPoint, data, worldWidth, leftEdge);
                if (x >= leftEdge + worldWidth) {
                    this.addInterpolatedNormalizedPoint(sampleBuffer, 1.0, firstDataPoint, data, worldWidth, leftEdge);
                }
                return data;
            }
            firstDataPoint = data;
lbl12:
            // 2 sources

            ** while (it.hasNext())
        }
lbl13:
        // 1 sources

        return firstDataPoint;
    }

    private void addInterpolatedNormalizedPoint(AveragingSampleBuffer sampleBuffer, double boundary, IXYData beforeData, IXYData afterData, long worldWidth, long leftEdge) {
        double n1 = this.getNormalizedX(beforeData, worldWidth, leftEdge);
        double n2 = this.getNormalizedX(afterData, worldWidth, leftEdge);
        double y1 = this.getY(beforeData);
        double y2 = this.getY(afterData);
        double k = (y2 - y1) / (n2 - n1);
        double yResult = (boundary - n1) * k + y1;
        sampleBuffer.addDataPoint(boundary, yResult);
    }

    private double getY(IXYData data) {
        return ((Number)data.getY()).doubleValue();
    }

    private void addXYDataPoint(AveragingSampleBuffer sampleBuffer, long worldWidth, long leftEdge, IXYData data) {
        double n = this.getNormalizedX(data, worldWidth, leftEdge);
        double y = ((Number)data.getY()).doubleValue();
        sampleBuffer.addDataPoint(n, y);
    }

    private double getNormalizedX(IXYData data, long worldWidth, long leftEdge) {
        return (double)(this.getXAsLong(data) - leftEdge) / (double)worldWidth;
    }

    private AveragingSampleBuffer createSubSampledBuffer(int width) {
        SamplePoint[] samplePoints = this.m_sampleBuffer.getSamples();
        AveragingSampleBuffer subSamplingBuffer = null;
        if (this.m_lastSubSampleWidth == width) {
            subSamplingBuffer = this.m_subSamplingBuffer;
            subSamplingBuffer.reset();
        } else {
            subSamplingBuffer = new AveragingSampleBuffer(width);
            this.m_lastSubSampleWidth = width;
        }
        int n = 0;
        while (n < samplePoints.length) {
            if (samplePoints[n].hasSample()) {
                subSamplingBuffer.addDataPoint((double)n / (double)samplePoints.length, samplePoints[n].y);
            }
            ++n;
        }
        return subSamplingBuffer;
    }

    @Override
    public DataSeries getDataSeries() {
        return this.m_dataSeries;
    }

    @Override
    public OptimizingProvider[] getChildren() {
        return new OptimizingProvider[0];
    }

    @Override
    public synchronized long getMaxX() {
        return this.m_endX;
    }

    @Override
    public synchronized long getMinX() {
        return this.m_startX;
    }

    @Override
    public double getMaxY() {
        return this.m_sampleBuffer.getMaxY();
    }

    @Override
    public double getMinY() {
        return this.m_sampleBuffer.getMinY();
    }

    @Override
    public synchronized void setRange(long start, long end) {
        this.m_requestedStartX = start;
        this.m_requestedEndX = end;
        this.update();
    }

    @Override
    public long getValueCount() {
        return this.m_sampleBuffer.getDataPointCount();
    }

    @Override
    public void setIntegrate(boolean integrate) {
    }
}

