/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.impl;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import se.hirt.greychart.TickFormatter;

public final class NanoTimestampFormatter
implements TickFormatter {
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long MILLIS_PER_SECOND = 1000000L;
    private static final long NANOS_PER_DAY = 2073600000000000L;
    private final NumberFormat m_format = NumberFormat.getInstance();
    private Precision m_precision = Precision.AUTOMATIC;
    private boolean m_alwaysShowDate = false;
    private String m_timeDateSeparator = " ";

    public String format(long value, long startTimestamp, long endTimestamp) {
        return this.format(value, startTimestamp, endTimestamp, null);
    }

    public String format(Number value, Number min, Number max, Number labelDistance) {
        long nanos1970timeStamp = value.longValue();
        long nanosDuration = max.longValue() - min.longValue();
        Date millisDate = new Date(nanos1970timeStamp / 1000000L);
        Precision precision = this.m_precision == Precision.AUTOMATIC ? Precision.getPrecisionForRange(nanosDuration) : this.m_precision;
        String text = new String();
        if (precision.isLargerThan(Precision.SECONDS) || this.getAlwaysShowDate()) {
            text = String.valueOf(text) + this.formatDate(precision, millisDate);
            text = String.valueOf(text) + this.getTimeDateSeapator();
        }
        if (precision.isLessThan(Precision.DAYS)) {
            text = String.valueOf(text) + this.formatTime(precision, millisDate);
            if (precision.isLessThan(Precision.SECONDS)) {
                text = String.valueOf(text) + this.formatSubSecond(precision, nanos1970timeStamp % 1000000000L);
            }
        }
        return text;
    }

    public String getUnitString(Number min, Number max) {
        return "";
    }

    protected String formatSubSecond(Precision precision, long nanos) {
        return " " + this.formatMillis(precision, (double)nanos / 1000000.0) + " ms";
    }

    protected String formatTime(Precision precision, Date date) {
        if (precision.isLargerThan(Precision.SECONDS)) {
            return SimpleDateFormat.getTimeInstance(3).format(date);
        }
        return SimpleDateFormat.getTimeInstance(2).format(date);
    }

    protected String formatDate(Precision precision, Date date) {
        if (precision == Precision.YEARS) {
            return new SimpleDateFormat("yyyy").format(date);
        }
        return SimpleDateFormat.getDateInstance(3).format(date);
    }

    protected String formatMillis(Precision precision, double millis) {
        this.m_format.setMinimumIntegerDigits(3);
        this.m_format.setMaximumIntegerDigits(3);
        this.m_format.setMinimumFractionDigits(precision.getFractionDigits());
        this.m_format.setMaximumFractionDigits(precision.getFractionDigits());
        return this.m_format.format(millis);
    }

    public final void setPrecision(Precision precision) {
        this.m_precision = precision;
    }

    public final Precision getPrecision() {
        return this.m_precision;
    }

    public final boolean getAlwaysShowDate() {
        return this.m_alwaysShowDate;
    }

    public final void setAlwaysShowDate(boolean alwaysShow) {
        this.m_alwaysShowDate = alwaysShow;
    }

    public final void setTimeDateSeapator(String separator) {
        this.m_timeDateSeparator = separator;
    }

    public final String getTimeDateSeapator() {
        return this.m_timeDateSeparator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Precision {
        NANOS(1L, 6),
        MICROS(1000L, 3),
        MILLIS(1000000L, 0),
        SECONDS(1000000000L, 0),
        MINUTES(60000000000L, 0),
        HOURS(3600000000000L, 0),
        DAYS(2073600000000000L, 0),
        MONTHS(62208000000000000L, 0),
        YEARS(756864000000000000L, 0),
        AUTOMATIC(0L, 0);

        private static final long CUT_OFF_RATIO = 10000L;
        private long m_nanos;
        private int m_fractionDigits;

        private Precision(long nanos, int digits) {
            this.m_nanos = nanos;
            this.m_fractionDigits = digits;
        }

        public boolean isLargerThan(Precision precision) {
            return precision.ordinal() < this.ordinal();
        }

        public boolean isLessThan(Precision precision) {
            return this.ordinal() < precision.ordinal();
        }

        public long inNanos() {
            return this.m_nanos;
        }

        public int getFractionDigits() {
            return this.m_fractionDigits;
        }

        public static Precision getPrecisionForRange(long duration) {
            Precision[] precisionArray = Precision.values();
            int n = precisionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Precision precision = precisionArray[n2];
                if (duration < 10000L * precision.inNanos() && precision != AUTOMATIC) {
                    return precision;
                }
                ++n2;
            }
            return YEARS;
        }
    }
}

