/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import se.hirt.greychart.AbstractSeriesRenderer;
import se.hirt.greychart.FontAndColors;
import se.hirt.greychart.GreyChart;
import se.hirt.greychart.GreyChartPanel;
import se.hirt.greychart.TitleRenderer;
import se.hirt.greychart.util.ChartRenderingToolkit;

public class DefaultTitleRenderer
extends AbstractSeriesRenderer
implements TitleRenderer {
    public static final float DEFAULT_MINIMUM_FONT_SIZE = FontAndColors.getDefaultFont().getSize();
    public static final float DEFAULT_TITLE_RELATIVE_FONT_SIZE = 0.04f;
    private Color m_textColor = FontAndColors.getDefaultMiddleColor();
    private float m_relativeFontSize = 0.04f;
    private Image m_titleImageCache;
    private String m_lastTitle;
    private Object cachedImageAntialiasingValue;
    private Rectangle m_lastRendered = new Rectangle(0, 0);

    public DefaultTitleRenderer(GreyChart owner) {
        this.setRelativeFontSize(0.04f);
        this.setMinimumFontSize(DEFAULT_MINIMUM_FONT_SIZE);
        this.m_owner = owner;
    }

    public void render(Graphics2D ctx, Rectangle targetArea, Rectangle fullGraphArea) {
        if (targetArea.height <= 0) {
            this.clearRenderedBounds();
            return;
        }
        String title = this.getTitle();
        if (!targetArea.equals(this.m_lastRendered) || title != this.m_lastTitle || ctx.getRenderingHint(RenderingHints.KEY_ANTIALIASING) != this.cachedImageAntialiasingValue) {
            float fontSize = this.getActualFontSize((float)fullGraphArea.height * this.getRelativeFontSize());
            Font font = null;
            font = ctx.getFont().getSize2D() < fontSize ? ctx.getFont().deriveFont(fontSize) : ctx.getFont();
            BufferedImage img = new BufferedImage((int)ctx.getFontMetrics(font).getStringBounds(title == null || title.equals("") ? " " : title, ctx).getWidth(), targetArea.height, 5);
            Graphics2D gctx = (Graphics2D)img.getGraphics();
            gctx.setFont(font);
            gctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, ctx.getRenderingHint(RenderingHints.KEY_ANTIALIASING));
            this.drawTitle(gctx, targetArea, title);
            this.m_titleImageCache = img;
            this.cachedImageAntialiasingValue = ctx.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            this.setRenderedBounds(targetArea);
            this.m_lastTitle = title;
            this.m_lastRendered.setBounds(targetArea);
        }
        int width = this.m_titleImageCache.getWidth(null);
        ctx.drawImage(this.m_titleImageCache, targetArea.x + (targetArea.width - width) / 2, targetArea.y, width, targetArea.height, null);
        if (GreyChartPanel.DEBUG) {
            ChartRenderingToolkit.markBoundary(ctx, targetArea.x, targetArea.y, targetArea.width, targetArea.height, Color.PINK);
        }
    }

    public Color getTextColor() {
        return this.m_textColor;
    }

    public void setTextColor(Color textColor) {
        this.m_textColor = textColor;
    }

    public Dimension getPreferredDimensions(Graphics2D ctx, Rectangle totalDrawingArea) {
        float fontSize = this.getActualFontSize((float)totalDrawingArea.height * this.getRelativeFontSize());
        FontMetrics fm = ctx.getFontMetrics(ctx.getFont().deriveFont(fontSize));
        Rectangle2D bounds = fm.getStringBounds(this.getTitle(), ctx);
        Dimension result = new Dimension((int)Math.ceil(bounds.getWidth()), (int)Math.ceil(bounds.getHeight() + (double)fm.getMaxDescent()));
        return result;
    }

    protected String getTitle() {
        return this.m_owner.getTitle();
    }

    public void setRelativeFontSize(float relativeFontSize) {
        this.m_relativeFontSize = relativeFontSize;
    }

    public float getRelativeFontSize() {
        return this.m_relativeFontSize;
    }

    public void drawTitle(Graphics2D ctx, Rectangle rect, String title) {
        this.setRenderedBounds(rect);
        if (GreyChartPanel.DEBUG) {
            ctx.setColor(Color.PINK);
        } else {
            ctx.setColor(this.getBackground());
        }
        ctx.fillRect(0, 0, rect.width, rect.height);
        ctx.setColor(this.m_textColor);
        Rectangle2D bounds = ctx.getFontMetrics().getStringBounds(this.getTitle(), ctx);
        ctx.drawString(title, 0, (int)(bounds.getHeight() - (double)ctx.getFontMetrics().getDescent()));
    }
}

