/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import se.hirt.greychart.TickFormatter;

public final class DateFormatter
implements TickFormatter {
    public static final long MILLISECOND = 1L;
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long FIVE_MINUTES = 300000L;
    public static final long QUARTER_HOUR = 900000L;
    public static final long THIRD_HOUR = 1200000L;
    public static final long HALF_HOUR = 1800000L;
    public static final long HOURS = 3600000L;
    public static final long QUARTER_DAY = 21600000L;
    public static final long HALF_DAY = 43200000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long MONTH = 2419200000L;
    public static final long YEAR = 31536000000L;
    private static final long[] RANGE_ARRAY = new long[]{1L, 1000L, 10000L, 600000L, 172800000L, 1209600000L, 6048000000L, 2419200000L, 31536000000L, Long.MAX_VALUE};
    private static final String[] FORMATTING_STRINGS = new String[]{"S", "s:SSS", "mm:ss", "HH:mm", "EEE HH:mm", "EEE", "ww", "MMMMM", "yyyy"};
    private static final String[] UNIT_STRINGS = new String[]{" (ms)", " (s:ms)", " (m:s)", " (h:m)", "", "", "", "", "", " (week)", "", "", "", ""};
    private static SimpleDateFormat[] m_formatterArray = new SimpleDateFormat[FORMATTING_STRINGS.length];
    private Date m_dateCache = new Date();

    public String format(Number value, Number min, Number max, Number labelInterval) {
        return this.getFormattedString(value.longValue(), this.getRangeIndex(max.longValue() - min.longValue()));
    }

    public String getUnitString(Number min, Number max) {
        return UNIT_STRINGS[this.getRangeIndex(max.longValue() - min.longValue())];
    }

    private synchronized SimpleDateFormat getDateFormat(int rangeIndex) {
        if (m_formatterArray[rangeIndex] == null) {
            DateFormatter.m_formatterArray[rangeIndex] = new SimpleDateFormat(FORMATTING_STRINGS[rangeIndex]);
        }
        return m_formatterArray[rangeIndex];
    }

    private String getFormattedString(long time, int rangeIndex) {
        this.m_dateCache.setTime(time);
        return this.getDateFormat(rangeIndex).format(this.m_dateCache);
    }

    private int getRangeIndex(long range) {
        int i = 0;
        while (i < RANGE_ARRAY.length) {
            if (range < RANGE_ARRAY[i]) {
                return i >= 1 ? i - 1 : 0;
            }
            ++i;
        }
        return 0;
    }
}

