/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.hirt.greychart.data.AbstractDataProvider;
import se.hirt.greychart.data.DataChangeEvent;
import se.hirt.greychart.data.DataChangeListener;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.DataSeriesProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeriesProvider<T>
extends AbstractDataProvider
implements DataSeriesProvider<T> {
    private final List<DataSeries<T>> dataSeries = new ArrayList<DataSeries<T>>();
    private final Map<DataSeries<T>, DataChangeListener> listeners = new HashMap<DataSeries<T>, DataChangeListener>();

    @Override
    public DataSeries<T>[] getDataSeries() {
        return this.dataSeries.toArray(new DataSeries[this.dataSeries.size()]);
    }

    @Override
    public boolean hasData() {
        return !this.dataSeries.isEmpty();
    }

    public void addDataSeries(DataSeries<T> series) {
        this.dataSeries.add(series);
        this.registerListener(series);
        this.fireDataChangeEvent(new DataChangeEvent(this, DataChangeEvent.ChangeType.TYPE_STRUCTURE_CHANGED));
    }

    public boolean removeDataSeries(DataSeries<T> series) {
        boolean result = this.dataSeries.remove(series);
        this.fireDataChangeEvent(new DataChangeEvent(this, DataChangeEvent.ChangeType.TYPE_STRUCTURE_CHANGED));
        return result;
    }

    private void registerListener(DataSeries<T> series) {
        DataChangeListener listener = new DataChangeListener(){

            public void onDataChange(DataChangeEvent event) {
                SeriesProvider.this.fireDataChangeEvent(new DataChangeEvent(SeriesProvider.this, event.getType()));
            }
        };
        this.listeners.put(series, listener);
        series.addChangeListener(listener);
    }
}

