/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart;

import java.awt.Color;
import java.awt.Font;
import java.util.logging.Level;
import javax.swing.UIManager;
import se.hirt.greychart.GreyChartPanel;

public final class FontAndColors {
    private static Color bgcolor = FontAndColors.createDefaultBackgroundColor();
    private static Color fgcolor = FontAndColors.createDefaultForegroundColor();
    private static Color middlecolor = FontAndColors.createDefaultMiddleColor();
    private static Font defaultFont = FontAndColors.createDefaultFont();

    private static Font createDefaultFont() {
        String fontName;
        int fontSize;
        try {
            Font currFont = UIManager.getFont("OptionPane.font");
            fontSize = currFont.getSize() * 5 / 6;
            fontName = currFont.getName();
        }
        catch (Exception e) {
            fontName = "SansSerif";
            fontSize = 12;
            GreyChartPanel.LOGGER.log(Level.WARNING, "Could not find option pane font, will proceed with default.", e);
        }
        return new Font(fontName, 0, fontSize);
    }

    private static Color createDefaultForegroundColor() {
        Color fgcolor;
        try {
            fgcolor = UIManager.getColor("windowText");
        }
        catch (Exception e) {
            fgcolor = Color.BLACK;
            GreyChartPanel.LOGGER.log(Level.WARNING, "Could not find windowText color, will proceed with default.", e);
        }
        return fgcolor;
    }

    private static Color createDefaultBackgroundColor() {
        Color bgcolor;
        try {
            bgcolor = UIManager.getColor("window");
        }
        catch (Exception e) {
            bgcolor = Color.WHITE;
            GreyChartPanel.LOGGER.log(Level.WARNING, "Could not find window color, will proceed with default.", e);
        }
        return bgcolor;
    }

    private static Color createDefaultMiddleColor() {
        int red = (fgcolor.getRed() + bgcolor.getRed()) / 2;
        int green = (fgcolor.getGreen() + bgcolor.getGreen()) / 2;
        int blue = (fgcolor.getBlue() + bgcolor.getBlue()) / 2;
        return new Color(red, green, blue);
    }

    public static Color getDefaultBackground() {
        return bgcolor;
    }

    public static Color getDefaultForeground() {
        return fgcolor;
    }

    public static Color getDefaultMiddleColor() {
        return middlecolor;
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }
}

