/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import se.hirt.greychart.ChartChangeEvent;
import se.hirt.greychart.ChartChangeListener;
import se.hirt.greychart.ChartRenderer;
import se.hirt.greychart.FontAndColors;
import se.hirt.greychart.IndexRenderer;
import se.hirt.greychart.PlotRenderer;
import se.hirt.greychart.SeriesGreyChart;
import se.hirt.greychart.data.DataChangeEvent;
import se.hirt.greychart.data.DataChangeListener;
import se.hirt.greychart.data.DataProvider;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.DataSeriesDescriptor;
import se.hirt.greychart.data.SeriesProvider;
import se.hirt.greychart.impl.DefaultDataSeriesDescriptor;

public abstract class AbstractGreyChart
implements SeriesGreyChart {
    private String m_title;
    private boolean m_useAntialiasing = true;
    private DataProvider m_dataProvider;
    protected PlotRenderer m_plotRenderer;
    protected DataChangeListener m_defaultDataChangeListener = new DefaultDataListener();
    protected ChartChangeEvent m_defaultChangeEvent;
    protected Color m_background = FontAndColors.getDefaultBackground();
    protected Color m_foreground = FontAndColors.getDefaultForeground();
    private ArrayList m_graphChangeListeners = new ArrayList(5);
    protected ChartRenderer m_titleRenderer;
    protected IndexRenderer m_indexRenderer;
    protected final Map<DataSeries, DataSeriesDescriptor> m_metaData = new HashMap<DataSeries, DataSeriesDescriptor>();
    private boolean m_isAutoUpdateOnDataChange;

    public AbstractGreyChart(String title) {
        this.m_defaultChangeEvent = new ChartChangeEvent(this, ChartChangeEvent.ChangeType.DATA_CHANGED);
        this.setTitle(title);
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setDataProvider(DataProvider provider) {
        if (this.m_dataProvider != null) {
            this.m_dataProvider.removeChangeListener(this.m_defaultDataChangeListener);
        }
        this.m_dataProvider = provider;
        this.m_dataProvider.addChangeListener(this.m_defaultDataChangeListener);
        this.fireChangeEvent(new ChartChangeEvent(this, ChartChangeEvent.ChangeType.DATA_STRUCTURE_CHANGED));
    }

    public DataProvider getDataProvider() {
        return this.m_dataProvider;
    }

    public void removeChangeListener(ChartChangeListener l) {
        this.m_graphChangeListeners.remove(l);
    }

    public void addChangeListener(ChartChangeListener l) {
        if (l == null) {
            throw new IllegalArgumentException("May not add null as chart change listener!");
        }
        this.m_graphChangeListeners.add(l);
    }

    public PlotRenderer getPlotRenderer() {
        return this.m_plotRenderer;
    }

    protected void fireChangeEvent(ChartChangeEvent event) {
        int i = 0;
        int size = this.m_graphChangeListeners.size();
        while (i < size) {
            ((ChartChangeListener)this.m_graphChangeListeners.get(i)).onChartChanged(event);
            ++i;
        }
    }

    public boolean isAntaliasingEnabled() {
        return this.m_useAntialiasing;
    }

    public void setAntialiasingEnabled(boolean enable) {
        this.m_useAntialiasing = enable;
    }

    public Color getBackground() {
        return this.m_background;
    }

    public void setBackground(Color bgColor) {
        this.m_background = bgColor;
    }

    public Color getForeground() {
        return this.m_foreground;
    }

    public void setForeground(Color fgColor) {
        this.m_foreground = fgColor;
    }

    public SeriesProvider getSeriesDataProvider() {
        return (SeriesProvider)this.getDataProvider();
    }

    public DefaultDataSeriesDescriptor getDescriptor(DataSeries series) {
        return (DefaultDataSeriesDescriptor)this.m_metaData.get(series);
    }

    public void setDescriptor(DataSeries series, DataSeriesDescriptor descriptor) {
        this.m_metaData.put(series, descriptor);
    }

    public DefaultDataSeriesDescriptor[] getDescriptors() {
        Collection<DataSeriesDescriptor> c = this.m_metaData.values();
        return c.toArray(new DefaultDataSeriesDescriptor[c.size()]);
    }

    public void setIndexRenderer(IndexRenderer indexRenderer) {
        this.m_indexRenderer = indexRenderer;
    }

    public IndexRenderer getIndexRenderer() {
        return this.m_indexRenderer;
    }

    public void setTitleRenderer(ChartRenderer titleRenderer) {
        this.m_titleRenderer = titleRenderer;
    }

    public ChartRenderer getTitleRenderer() {
        return this.m_titleRenderer;
    }

    public void setAutoUpdateOnDataChange(boolean enable) {
        this.m_isAutoUpdateOnDataChange = enable;
    }

    public boolean isAutoUpdateOnDataChange() {
        return this.m_isAutoUpdateOnDataChange;
    }

    class DefaultDataListener
    implements DataChangeListener {
        DefaultDataListener() {
        }

        public void onDataChange(DataChangeEvent event) {
            if (AbstractGreyChart.this.isAutoUpdateOnDataChange()) {
                AbstractGreyChart.this.fireChangeEvent(AbstractGreyChart.this.m_defaultChangeEvent);
            }
        }
    }
}

