/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ide.jdt;

import com.jrockit.mc.ide.jdt.Messages;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

final class OpenTypeRunnable
implements Runnable {
    private final String m_filter;
    private final String m_title;
    private final IJavaSearchScope m_scope;
    private final Shell m_shell;
    private IType m_selectedType;

    public OpenTypeRunnable(Shell shell, IType[] types, String filter, String title) {
        this.m_filter = filter;
        this.m_shell = shell;
        this.m_scope = SearchEngine.createJavaSearchScope((IJavaElement[])types);
        this.m_title = title;
    }

    public void run() {
        try {
            this.showDialog();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showDialog() throws JavaModelException {
        Object[] results;
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.m_shell, (IRunnableContext)new ProgressMonitorDialog(this.m_shell), (IJavaSearchScope)this.m_scope, (int)256, (boolean)false, (String)this.m_filter);
        dialog.setTitle(this.m_title);
        dialog.setMessage(Messages.OpenTypeRunnable_DIALOG_MESSAGE_MATCHING_ITEMS);
        if (dialog.open() == 0 && (results = dialog.getResult()).length > 0 && results[0] instanceof IType) {
            this.setSelectedType((IType)results[0]);
        }
    }

    private void setSelectedType(IType type) {
        this.m_selectedType = type;
    }

    public IType getSelectedType() {
        return this.m_selectedType;
    }
}

