/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ide.jdt;

import com.jrockit.mc.common.IMCType;
import com.jrockit.mc.common.internal.MethodToolkit;
import com.jrockit.mc.ide.jdt.JumpToSourceJob;
import com.jrockit.mc.ide.jdt.JumpToSourceToolkit;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.ui.IWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JumpToTypeJob
extends JumpToSourceJob {
    public static void schedule(IWorkbenchSite site, IMCType type) {
        Job job = JumpToTypeJob.createJob(site, type);
        if (job != null) {
            job.schedule();
        }
    }

    static Job createJob(IWorkbenchSite site, IMCType type) {
        String topLevelType = MethodToolkit.topLevelType((String)type.getTypeName());
        String nestedTypes = MethodToolkit.nestedTypes((String)type.getTypeName());
        String qualifiedClassName = MethodToolkit.formatQualifiedName((String)type.getPackageName(), (String)topLevelType);
        if (qualifiedClassName != null) {
            return new JumpToTypeJob(site, qualifiedClassName, nestedTypes);
        }
        return null;
    }

    public JumpToTypeJob(IWorkbenchSite site, String className, String nestedTypes) {
        super(site, className, nestedTypes, null);
    }

    @Override
    protected Map<IJavaElement, IJavaElement> createTypeToJavaElementMap(IJavaElement[] elements) {
        HashMap<IJavaElement, IJavaElement> map = new HashMap<IJavaElement, IJavaElement>();
        int n = 0;
        while (n < elements.length) {
            map.put(elements[n], elements[n]);
            ++n;
        }
        return map;
    }

    @Override
    protected IJavaElement[] findJavaElements(IProgressMonitor monitor) throws CoreException {
        return JumpToSourceToolkit.findOpenableTypeElements(this.m_className, this.m_nestedTypes, monitor);
    }

    @Override
    protected String createTitle(IJavaElement element) {
        return "Open type";
    }
}

