/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ide.jdt;

import com.jrockit.mc.ide.jdt.OpenSourceRequestor;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;

public class JumpToSourceToolkit {
    static IMethod findMethod(IType type, String methodName, String descriptor) throws JavaModelException {
        if (methodName == null) {
            return null;
        }
        if (descriptor != null) {
            String[] params;
            IMethod method;
            if (methodName.startsWith("<init>")) {
                methodName = type.getElementName();
            }
            if ((method = type.getMethod(methodName, params = Signature.getParameterTypes((String)descriptor))) != null && method.exists()) {
                return method;
            }
        }
        IMethod[] methods = type.getMethods();
        int n = 0;
        while (n < methods.length) {
            if (methodName.equals(methods[n].getElementName())) {
                return methods[n];
            }
            ++n;
        }
        return null;
    }

    static IJavaElement[] findMethods(IType[] types, String methodName, String descriptor) throws JavaModelException {
        ArrayList<Object> results = new ArrayList<Object>();
        int n = 0;
        while (n < types.length) {
            IMethod method = JumpToSourceToolkit.findMethod(types[n], methodName, descriptor);
            if (method != null) {
                results.add(method);
            } else {
                results.add(types[n]);
            }
            ++n;
        }
        return results.toArray(new IJavaElement[results.size()]);
    }

    private static IType[] findSourceFileTypesInWorkspace(String declaringType, IProgressMonitor monitor) throws CoreException {
        OpenSourceRequestor collector = new OpenSourceRequestor();
        SearchEngine engine = new SearchEngine();
        SearchParticipant[] searchParticipants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        SearchPattern pattern = SearchPattern.createPattern((String)declaringType, (int)0, (int)0, (int)0);
        engine.search(pattern, searchParticipants, SearchEngine.createWorkspaceScope(), (SearchRequestor)collector, monitor);
        return collector.getResults();
    }

    public static IJavaElement[] findOpenableMethodElements(String declaringTypeName, String methodName, String descriptor, String nestedTypes, IProgressMonitor monitor) throws CoreException {
        return JumpToSourceToolkit.findMethods(JumpToSourceToolkit.findTypes(JumpToSourceToolkit.findSourceFileTypesInWorkspace(declaringTypeName, monitor), nestedTypes), methodName, descriptor);
    }

    public static IJavaElement[] findOpenableTypeElements(String declaringTypeName, String nestedTypes, IProgressMonitor monitor) throws CoreException {
        return JumpToSourceToolkit.findTypes(JumpToSourceToolkit.findSourceFileTypesInWorkspace(declaringTypeName, monitor), nestedTypes);
    }

    public static IType[] findTypes(IType[] elements, String nestedTypes) {
        ArrayList<IType> list = new ArrayList<IType>(elements.length);
        int n = 0;
        while (n < elements.length) {
            IType type = JumpToSourceToolkit.findNestedType(elements[n], nestedTypes);
            if (type != null) {
                list.add(type);
            }
            ++n;
        }
        return list.toArray(new IType[list.size()]);
    }

    public static IType findNestedType(IType type, String nestedTypeString) {
        String nestedTypeName;
        IType nestedType;
        if (nestedTypeString != null && (nestedType = type.getType(nestedTypeName = JumpToSourceToolkit.getFirstNestedType(nestedTypeString))) != null && nestedType.exists()) {
            return JumpToSourceToolkit.findNestedType(nestedType, JumpToSourceToolkit.getRemainingNestedTypes(nestedTypeString));
        }
        return type;
    }

    public static String getFirstNestedType(String nestedTypeString) {
        int index = nestedTypeString.indexOf(36);
        if (index != -1) {
            return nestedTypeString.substring(0, index);
        }
        return nestedTypeString;
    }

    public static String getRemainingNestedTypes(String nestedTypeString) {
        int index = nestedTypeString.indexOf(36);
        if (index != -1 && index + 1 < nestedTypeString.length()) {
            return nestedTypeString.substring(index + 1);
        }
        return null;
    }
}

