/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ide.jdt;

import com.jrockit.mc.core.misc.StatusFactory;
import com.jrockit.mc.ide.jdt.Messages;
import com.jrockit.mc.ide.jdt.OpenTypeRunnable;
import com.jrockit.mc.ide.jdt.SourceJobChangeListener;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JumpToSourceJob
extends Job {
    public static final int NO_SOURCE_FOUND = 2;
    protected final IWorkbenchSite m_site;
    protected final String m_className;
    protected final String m_nestedTypes;
    protected final Integer m_lineNumber;

    public JumpToSourceJob(IWorkbenchSite site, String className, String nestedTypes, Integer lineNumber) {
        super(Messages.JumpToSourceJob_LOOKING_FOR_JAVA_SOURCE_CODE_JOB_TITLE);
        this.m_className = className;
        this.m_nestedTypes = nestedTypes;
        this.m_site = site;
        this.m_lineNumber = lineNumber;
    }

    public static void addJobMessageListener(IWorkbenchPart part, Job job) {
        IMessageManager man = (IMessageManager)part.getAdapter(IMessageManager.class);
        if (man != null) {
            Display display = part.getSite().getShell().getDisplay();
            job.addJobChangeListener((IJobChangeListener)new SourceJobChangeListener(man, display));
        }
        job.schedule();
    }

    private void runSafeInUI(final Runnable runnable) {
        final Display display = this.m_site.getWorkbenchWindow().getShell().getDisplay();
        if (!display.isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    if (!display.isDisposed()) {
                        runnable.run();
                    }
                }
            });
        }
    }

    public void jumptoElements(final IJavaElement element) {
        this.runSafeInUI(new Runnable(){

            public void run() {
                OpenAction a = new OpenAction(JumpToSourceJob.this.m_site);
                a.run((IStructuredSelection)new StructuredSelection((Object)element));
            }
        });
    }

    /*
     * Loose catch block
     */
    public void selectSourceLine() {
        block10: {
            IEditorPart editorPart;
            IWorkbenchPage page = this.m_site.getWorkbenchWindow().getActivePage();
            if (page != null && (editorPart = this.m_site.getWorkbenchWindow().getActivePage().getActiveEditor()) instanceof ITextEditor && this.m_lineNumber != null && this.m_lineNumber >= 0) {
                IEditorInput editorInput = null;
                IDocumentProvider provider = null;
                try {
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    provider = textEditor.getDocumentProvider();
                    editorInput = textEditor.getEditorInput();
                    provider.connect((Object)textEditor.getEditorInput());
                    IDocument document = provider.getDocument((Object)editorInput);
                    IRegion line = document.getLineInformation(this.m_lineNumber.intValue());
                    textEditor.selectAndReveal(line.getOffset(), line.getLength());
                    provider.disconnect((Object)textEditor.getEditorInput());
                }
                catch (CoreException coreException) {
                    if (editorInput != null && provider != null) {
                        provider.disconnect((Object)editorInput);
                    }
                    break block10;
                }
                catch (BadLocationException badLocationException) {
                    if (editorInput != null && provider != null) {
                        provider.disconnect((Object)editorInput);
                    }
                    break block10;
                    catch (Throwable throwable) {
                        if (editorInput != null && provider != null) {
                            provider.disconnect(editorInput);
                        }
                        throw throwable;
                    }
                }
                if (editorInput == null || provider == null) break block10;
                provider.disconnect((Object)editorInput);
            }
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.JumpToSourceJob_TASK_LOOKING_FOR_SOURCE, -1);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
            IJavaElement[] javaElements = this.findJavaElements((IProgressMonitor)subMonitor);
            if (javaElements != null && javaElements.length != 0) {
                Map<IJavaElement, IJavaElement> typeMap = this.createTypeToJavaElementMap(javaElements);
                if (typeMap.keySet().size() > 0) {
                    IType[] types = typeMap.keySet().toArray(new IType[typeMap.keySet().size()]);
                    IType selectedType = types[0];
                    if (types.length > 1) {
                        String title = this.createTitle(javaElements[0]);
                        selectedType = this.showSelectionDialog(types, types[0].getElementName(), title);
                        if (selectedType == null) {
                            IStatus iStatus = StatusFactory.createOk((String)Messages.JumpToSourceJob_OPEN_SOURCE_CANCELED_BY_USER_TEXT);
                            return iStatus;
                        }
                    }
                    IJavaElement selectedElement = typeMap.get(selectedType);
                    assert (selectedElement != null);
                    if (selectedElement != null) {
                        this.jumptoElements(selectedElement);
                        IStatus iStatus = StatusFactory.createOk((String)"");
                        return iStatus;
                    }
                }
                IStatus iStatus = JumpToSourceJob.createNoSourceFoundStatus();
                return iStatus;
            }
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            StatusFactory.createErr((String)Messages.JumpToSourceJob_ERROR_WHEN_LOOKING_FOR_JAVA_SOURCE_STATUS_DESCRIPTION, (Throwable)e, (boolean)false);
        }
        finally {
            monitor.done();
        }
        return JumpToSourceJob.createNoSourceFoundStatus();
    }

    public static IStatus createNoSourceFoundStatus() {
        return new Status(0, "com.jrockit.mc.core", 2, Messages.JumpToSourceJob_SOURCE_CODE_NOT_FOUND_STATUS_DESCRIPTION, null);
    }

    protected abstract Map<IJavaElement, IJavaElement> createTypeToJavaElementMap(IJavaElement[] var1);

    protected abstract IJavaElement[] findJavaElements(IProgressMonitor var1) throws CoreException;

    protected abstract String createTitle(IJavaElement var1);

    public IType showSelectionDialog(IType[] types, String filter, String title) {
        Shell shell = this.m_site.getWorkbenchWindow().getShell();
        OpenTypeRunnable runnable = new OpenTypeRunnable(shell, types, filter, title);
        this.runSafeInUI(runnable);
        return runnable.getSelectedType();
    }
}

