/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ide.jdt;

import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.common.internal.MethodToolkit;
import com.jrockit.mc.ide.jdt.JumpToSourceJob;
import com.jrockit.mc.ide.jdt.JumpToSourceToolkit;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.ui.IWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JumpToMethodJob
extends JumpToSourceJob {
    protected final String m_methodName;
    protected final String m_descriptor;

    public static void schedule(IWorkbenchSite site, IMCMethod method) {
        Job job = JumpToMethodJob.createJob(site, method);
        if (job != null) {
            job.schedule();
        }
    }

    public static Job createJob(IWorkbenchSite site, IMCMethod method) {
        String className = method.getClassName();
        if (className != null) {
            String topLevelType = MethodToolkit.topLevelType((String)className);
            String nestedTypes = MethodToolkit.nestedTypes((String)className);
            String qualifiedClassName = MethodToolkit.formatQualifiedName((String)method.getPackageName(), (String)topLevelType);
            if (qualifiedClassName != null) {
                String meth = method.getMethodName();
                String desc = method.getFormalDescriptor();
                return new JumpToMethodJob(site, qualifiedClassName, meth, desc, nestedTypes, method.getLineNumber());
            }
        }
        return null;
    }

    public JumpToMethodJob(IWorkbenchSite site, String className, String methodName, String descriptor, String nestedTypes, Integer lineNumber) {
        super(site, className, nestedTypes, lineNumber);
        this.m_methodName = methodName;
        this.m_descriptor = descriptor;
    }

    @Override
    protected Map<IJavaElement, IJavaElement> createTypeToJavaElementMap(IJavaElement[] elements) {
        HashMap<IJavaElement, IJavaElement> map = new HashMap<IJavaElement, IJavaElement>();
        int n = 0;
        while (n < elements.length) {
            if (elements[n] instanceof IMethod) {
                map.put((IJavaElement)((IMethod)elements[n]).getDeclaringType(), elements[n]);
            } else {
                map.put(elements[n], elements[n]);
            }
            ++n;
        }
        return map;
    }

    @Override
    protected IJavaElement[] findJavaElements(IProgressMonitor monitor) throws CoreException {
        return JumpToSourceToolkit.findOpenableMethodElements(this.m_className, this.m_methodName, this.m_descriptor, this.m_nestedTypes, monitor);
    }

    @Override
    protected String createTitle(IJavaElement element) {
        return "Open type for method: " + ((IMethod)element).getElementName();
    }
}

