/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.alert;

import com.jrockit.mc.alert.AlertPlugin;
import com.jrockit.mc.alert.TriggerApplicationAlert;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.triggers.TriggerAction;
import com.jrockit.mc.rjmx.notification.NotificationEvent;
import com.jrockit.mc.rjmx.notification.internal.NotificationToolkit;
import com.jrockit.mc.rjmx.proxy.IProxyOperations;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;

public class TriggerActionThreadStackDump
extends TriggerAction {
    private static final String XML_ELEMENT_LOG_TO_FILE = "log_to_file";
    private static final String XML_ELEMENT_SHOW_APPLICATION_ALERT = "show_application_alert";
    public static final String XML_ELEMENT_LOG_FILE_NAME = "log_filename";
    private TriggerApplicationAlert m_applicationAlertAction;
    private FileWriter m_file;
    private PrintWriter m_printWriter;
    static /* synthetic */ Class class$0;

    public void handleNotificationEvent(NotificationEvent e) {
        try {
            IConnectionHandle iConnectionHandle = e.getSource();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.proxy.IProxyOperations");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String stackDump = ((IProxyOperations)iConnectionHandle.getService((Class)clazz)).getThreadStackDump();
            NotificationEvent newEvent = new NotificationEvent(e.getSource(), e.getRule(), (Object)stackDump, e.wasTriggered());
            if (this.getShowApplicationAlert()) {
                this.getApplicationAlertAction().handleNotificationEvent(newEvent);
            }
            if (this.getLogToFile()) {
                NotificationToolkit.prettyPrint((PrintWriter)this.getPrintWriter(), (NotificationEvent)e);
                this.getPrintWriter().println(stackDump);
                this.getPrintWriter().flush();
                if (this.getPrintWriter().checkError()) {
                    AlertPlugin.getDefault().getLogger().severe("Can't write to log file " + this.getName());
                }
            }
        }
        catch (IOException e1) {
            AlertPlugin.getDefault().getLogger().log(Level.SEVERE, "Can't write to log file " + this.getName(), e1);
        }
    }

    private TriggerApplicationAlert getApplicationAlertAction() {
        if (this.m_applicationAlertAction == null) {
            this.m_applicationAlertAction = new TriggerApplicationAlert();
        }
        return this.m_applicationAlertAction;
    }

    public boolean getShowApplicationAlert() {
        return this.getSetting(XML_ELEMENT_SHOW_APPLICATION_ALERT).getBoolean();
    }

    public boolean getLogToFile() {
        return this.getSetting(XML_ELEMENT_LOG_TO_FILE).getBoolean();
    }

    public String toString() {
        return this.getName();
    }

    public String getLogFileName() {
        return this.getSetting(XML_ELEMENT_LOG_FILE_NAME).getFilename();
    }

    private PrintWriter getPrintWriter() {
        if (this.m_printWriter == null) {
            try {
                this.m_file = new FileWriter(this.getLogFileName(), true);
                this.m_printWriter = new PrintWriter(this.m_file);
            }
            catch (IOException e) {
                AlertPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not log stack dump to file!", e);
            }
        }
        return this.m_printWriter;
    }
}

