/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.alert;

import com.jrockit.mc.alert.AlertAction;
import com.jrockit.mc.alert.AlertDialog;
import com.jrockit.mc.alert.Messages;
import com.jrockit.mc.console.ui.notification.NotificationPlugin;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.MCAbstractUIPlugin;
import com.jrockit.mc.core.idesupport.IIDESupport;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.rjmx.notification.NotificationEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.osgi.framework.BundleContext;

public class AlertPlugin
extends MCAbstractUIPlugin {
    public static final String PLUGIN_ID = "com.jrockit.mc.alert";
    public static final String IMAGE_ALERT_BANNER = "AlertBanner";
    public static final String PREF_KEY_POPUP = "POPUP";
    private static final int MAX_ALERT_SIZE = 1000;
    private static AlertPlugin plugin;
    private AlertDialog dialog;
    private ArrayList alerts = new ArrayList();

    public AlertPlugin() {
        super(PLUGIN_ID);
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault(PREF_KEY_POPUP, true);
        NotificationPlugin.getDefault().registerShowAlertsAction((IActionDelegate)new AlertAction());
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static AlertPlugin getDefault() {
        return plugin;
    }

    public synchronized void addNotificationEvent(NotificationEvent e) {
        if (this.alerts.size() >= 1000) {
            this.alerts.remove(0);
        }
        this.alerts.add(e);
        this.showDialog(false);
        this.showTrayPopup(e);
    }

    private void showTrayPopup(NotificationEvent e) {
        final IIDESupport iSupport = CorePlugin.getDefault().getIDESupport();
        if (iSupport.getTrayManager() != null) {
            final String message = this.createMessage(e);
            final String title = Messages.AlertPlugin_TRIGGER_ALERT_TEXT;
            int style = 4104;
            DisplayToolkit.safeAsyncExec((Display)AlertPlugin.getDefault().getWorkbench().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    iSupport.getTrayManager().showTooltip(title, message, 4104);
                }
            });
        }
    }

    public String createMessage(NotificationEvent ne) {
        Date d = ne.getCreationTime();
        String message = MessageFormat.format(Messages.AlertPlugin_RULE_X_Y_TEXT, ne.getRule().getRulePath(), ne.getRule().getName());
        if (d != null) {
            DateFormat df1 = DateFormat.getDateInstance(3);
            DateFormat df2 = DateFormat.getTimeInstance(2);
            message = String.valueOf(message) + MessageFormat.format(Messages.AlertPlugin_TIME_X_Y_TEXT, df1.format(d), df2.format(d));
        }
        message = String.valueOf(message) + MessageFormat.format(Messages.AlertPlugin_SOURCE_X_TEXT, ne.getConnectorSourceDescription());
        return message;
    }

    public void setPopup(boolean popup) {
        this.getPreferenceStore().setValue(PREF_KEY_POPUP, popup);
    }

    public boolean getPopup() {
        return this.getPreferenceStore().getBoolean(PREF_KEY_POPUP);
    }

    public void showDialog(boolean alwaysShow) {
        if (this.getPopup() || alwaysShow || this.hasDialog()) {
            DisplayToolkit.safeAsyncExec((Display)AlertPlugin.getDefault().getWorkbench().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    Display display = AlertPlugin.getDefault().getWorkbench().getDisplay();
                    Shell shell = display.getActiveShell();
                    if (shell != null && !shell.isDisposed()) {
                        if (!AlertPlugin.this.hasDialog()) {
                            AlertPlugin.this.dialog = AlertPlugin.createDialog(shell);
                        }
                        if (AlertPlugin.this.dialog != null) {
                            AlertPlugin.this.dialog.open();
                            AlertPlugin.this.dialog.refreshAlertDialog();
                        }
                    }
                }
            });
        }
    }

    public boolean hasDialog() {
        if (this.dialog == null) {
            return false;
        }
        if (this.dialog.getShell() == null) {
            return false;
        }
        return !this.dialog.getShell().isDisposed();
    }

    public static AlertDialog createDialog(Shell shell) {
        Display display = AlertPlugin.getDefault().getWorkbench().getDisplay();
        if (display != null && !display.isDisposed() && display.getActiveShell() != null && !display.getActiveShell().isDisposed()) {
            return new AlertDialog(display.getActiveShell());
        }
        return null;
    }

    public synchronized void clearNotificationEventLog() {
        this.alerts.clear();
    }

    public synchronized Object[] getAlerts() {
        return this.alerts.toArray();
    }

    public Image getImage(String image) {
        return this.getImageRegistry().get(image);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(IMAGE_ALERT_BANNER, this.getImageDescriptor("icons/trigger-alerts-wiz.gif").createImage());
    }
}

