/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.util;

import com.jrockit.mc.components.ui.behaviors.IStatusListener;
import com.jrockit.mc.components.ui.behaviors.IStatusProvider;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class StatusProvider
implements IStatusProvider {
    private final ListenerList m_listenerList = new ListenerList();
    private final Map<IStatusProvider, IStatusListener> m_providers = Collections.synchronizedMap(new IdentityHashMap());

    public final void addStatusListener(IStatusListener listener) {
        this.m_listenerList.add((Object)listener);
    }

    public final void removeStatusListener(IStatusListener listener) {
        this.m_listenerList.remove((Object)listener);
    }

    public final void addStatusProvider(IStatusProvider provider) {
        IStatusListener listener = new IStatusListener(){

            public void onChange(IStatus status) {
                StatusProvider.this.fireChange(status);
            }
        };
        provider.addStatusListener(listener);
        this.m_providers.put(provider, listener);
    }

    public final void fireChange(IStatus status) {
        Object[] objectArray = this.m_listenerList.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IStatusListener listener = (IStatusListener)object;
            listener.onChange(status);
            ++n2;
        }
    }

    public final void removeStatusProvider(IStatusProvider provider) {
        IStatusListener statusListener = this.m_providers.get(provider);
        if (statusListener != null) {
            this.m_providers.remove(provider);
        }
        this.m_providers.remove(provider);
    }

    public final void clear() {
        this.clearListeners();
        this.clearProviders();
    }

    private void clearProviders() {
        this.m_providers.clear();
    }

    private void clearListeners() {
        this.m_listenerList.clear();
    }

    public IStatus getStatus() {
        Object[] objects = this.m_providers.keySet().toArray();
        IStatus[] status = new IStatus[objects.length];
        int n = 0;
        while (n < objects.length) {
            IStatusProvider sp = (IStatusProvider)objects[n];
            status[n] = sp.getStatus();
            ++n;
        }
        if (status.length == 0) {
            return new Status(0, "com.jrockit.mc.components.ui", "OK.");
        }
        if (status.length == 1) {
            return status[0];
        }
        return new MultiStatus("com.jrockit.mc.components.ui", 0, status, "Multi Status", null);
    }
}

