/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.text;

import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.core.handlers.ExternalUrlAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public final class TextComponent
extends AbstractUIComponent {
    public Control createPart(Composite parent) {
        FormText text = new FormText(parent, 0);
        text.setText(this.getText(), this.getParseTags(), false);
        this.hookLinkListener(text);
        return text;
    }

    private void hookLinkListener(FormText text) {
        if (this.getParseTags()) {
            text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    Object o = e.data;
                    if (o instanceof String) {
                        TextComponent.this.goToUrl((String)o);
                    }
                }
            });
        }
    }

    private void goToUrl(String url) {
        new ExternalUrlAction(url, "").run();
    }

    private boolean getParseTags() {
        return (Boolean)this.getComponentSettings().getChildObject("parseTags", Boolean.class);
    }

    private String getText() {
        return (String)this.getComponentSettings().getChildObject("text", String.class);
    }
}

