/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.tab;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.tab.BaseDescriptor;
import com.jrockit.mc.components.ui.tab.ImageConverter;
import com.jrockit.mc.components.ui.tab.TabItemDescriptor;
import com.jrockit.mc.components.ui.util.ImageDescriptor;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TabGroupDescriptor
extends BaseDescriptor {
    private static final String TABS = "tabs";
    private static final String GROUPS = "groups";
    public static final String ATTRIBUTE_ICON_LARGE_NAME = "iconLarge";

    static {
        PersistenceToolkit.registerFetcher(TabGroupDescriptor.class, (ISettingFetcher)new ISettingFetcher<TabGroupDescriptor>(){

            public Setting getSetting(TabGroupDescriptor tabGroup) {
                return tabGroup.getSetting();
            }
        });
    }

    public TabGroupDescriptor() {
        super("myTabGroup");
        this.setName(Messages.TAB_GROUP_DEFAULT_NAME_TEXT);
        this.setLargeIcon(this.createDefaultLarge(Display.getCurrent()));
    }

    protected ImageDescriptor createDefaultLarge(Display display) {
        Image image = this.createDefaultLargeIcon((Device)display);
        ImageDescriptor s = ImageConverter.createImageDescriptor(image);
        image.dispose();
        return s;
    }

    public List<TabGroupDescriptor> getGroups() {
        return (List)this.getSetting().getChildObject(GROUPS, new Type(List.class, new Type[]{new Type(TabGroupDescriptor.class)}));
    }

    public List<TabItemDescriptor> getTabs() {
        return (List)this.getSetting().getChildObject(TABS, new Type(List.class, new Type[]{new Type(TabItemDescriptor.class)}));
    }

    public void setLargeIcon(ImageDescriptor descriptor) {
        this.getSetting().setChildObject(ATTRIBUTE_ICON_LARGE_NAME, (Object)descriptor);
    }

    public ImageDescriptor getLargeIcon() {
        return (ImageDescriptor)this.getSetting().getChildObject(ATTRIBUTE_ICON_LARGE_NAME, ImageDescriptor.class);
    }

    @Override
    public Image createDefaultLargeIcon(Device device) {
        return new Image(device, ComponentsPlugin.getDefault().getImage("defaultGroupLarge.png"), 0);
    }

    @Override
    public Image createDefaultIcon(Device device) {
        return new Image(device, ComponentsPlugin.getDefault().getImage("defaultGroup.gif"), 0);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getName() + ", " + this.getDescription() + "]";
    }
}

