/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.settings.Input;
import com.jrockit.mc.core.CorePlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StringInput
extends Input {
    private boolean m_allowEmpty = true;
    private boolean m_allowSpaces = true;
    private boolean m_readOnly = false;
    private boolean m_multiLine = false;
    private ControlDecoration m_controlDecoration;
    private Text m_text;

    public StringInput(String property, String name) {
        super(property, name);
    }

    public final StringInput setAllowEmpty(boolean allowEmpty) {
        this.m_allowEmpty = allowEmpty;
        return this;
    }

    public final StringInput setAllowSpace(boolean allowSpaces) {
        this.m_allowSpaces = allowSpaces;
        return this;
    }

    public final StringInput setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
        return this;
    }

    public final StringInput setMultiLine(boolean multiLine) {
        this.m_multiLine = multiLine;
        return this;
    }

    public void create(Composite parent, int horizontalSpan) {
        GridData gdLabel = new GridData(4, 4, false, false);
        gdLabel.horizontalSpan = 1;
        gdLabel.verticalAlignment = this.isMulitiLine() ? 128 : 0x1000000;
        Label label = this.createLabel(parent);
        label.setLayoutData((Object)gdLabel);
        GridData gdText = new GridData(4, 4, true, this.isMulitiLine());
        gdText.horizontalSpan = horizontalSpan - 1;
        if (this.isMulitiLine()) {
            gdText.heightHint = 200;
        }
        this.m_text = this.createText(parent);
        this.m_text.setLayoutData((Object)gdText);
    }

    protected final boolean isMulitiLine() {
        return this.m_multiLine;
    }

    protected final Label createLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.getName());
        return label;
    }

    protected void createTextWithLayout(Composite parent, int span) {
        GridData gdText = new GridData(4, 4, true, this.isMulitiLine());
        gdText.horizontalSpan = span;
        this.m_text = this.createText(parent);
        this.m_text.setLayoutData((Object)gdText);
    }

    private Text createText(Composite parent) {
        Text text = new Text(parent, (this.m_multiLine ? 514 : 0) | 0x800 | 0x800);
        text.setEditable(!this.m_readOnly);
        this.m_controlDecoration = new ControlDecoration((Control)text, 131072);
        this.m_controlDecoration.setImage(CorePlugin.getDefault().getImage("error_obj.gif"));
        this.m_controlDecoration.hide();
        text.setText("");
        text.setEnabled(false);
        this.hookTextListener(text);
        return text;
    }

    public IStatus getStatus() {
        if (!this.isReadOnly()) {
            if (this.violatesAllowEmpty()) {
                return new Status(4, "com.jrockit.mc.components.ui", Messages.STRING_INPUT_MUST_CONTAIN_AT_LEAST_ONE_CHARACTER_TEXT);
            }
            if (this.violatesAllowSpaces()) {
                return new Status(4, "com.jrockit.mc.components.ui", Messages.STRING_INPUT_SPACE_NOT_ALLOWED_TEXT);
            }
        }
        return new Status(0, "com.jrockit.mc.components.ui", Messages.STRING_INPUT_VALID_INPUT);
    }

    private boolean isReadOnly() {
        return this.m_readOnly;
    }

    private boolean violatesAllowSpaces() {
        return !this.m_allowSpaces && this.getPropertyValue().contains(" ");
    }

    private boolean violatesAllowEmpty() {
        return !this.m_allowEmpty && this.getPropertyValue().length() == 0;
    }

    protected final ControlDecoration getControlDecoration() {
        return this.m_controlDecoration;
    }

    protected void hookTextListener(final Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StringInput.this.isEnabled()) {
                    StringInput.this.setPropertyValue(text.getText());
                    StringInput.this.markStale();
                }
            }
        });
    }

    public void refresh() {
        this.m_text.setEnabled(this.isEnabled());
        if (this.isEnabled()) {
            this.updateControlDecoration();
            String p = this.getPropertyValue();
            if (!this.m_text.getText().equals(p)) {
                this.m_text.setText(this.getPropertyValue());
            }
        } else {
            this.m_text.setText("");
        }
    }

    protected final void updateControlDecoration() {
        IStatus status = this.getStatus();
        switch (status.getSeverity()) {
            case 1: {
                this.setInfoDecoration(status);
                break;
            }
            case 0: {
                this.setOkDecoration(status);
                break;
            }
            case 2: {
                this.setWarningDecoration(status);
                break;
            }
            case 4: {
                this.setErrorDecoration(status);
                break;
            }
            default: {
                throw new RuntimeException("Unknown status severity " + status.getSeverity());
            }
        }
    }

    protected final void setInfoDecoration(IStatus status) {
        this.setOkDecoration(status);
    }

    protected final void setErrorDecoration(IStatus status) {
        this.getControlDecoration().setImage(CorePlugin.getDefault().getImage("error_obj.gif"));
        this.getControlDecoration().setDescriptionText(status.getMessage());
        this.getControlDecoration().show();
    }

    protected final void setWarningDecoration(IStatus status) {
        this.getControlDecoration().setImage(CorePlugin.getDefault().getImage("alert_obj.gif"));
        this.getControlDecoration().setDescriptionText(status.getMessage());
        this.getControlDecoration().show();
    }

    protected final void setOkDecoration(IStatus status) {
        this.getControlDecoration().setDescriptionText(null);
        this.getControlDecoration().hide();
    }
}

