/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.behaviors.IStatusListener;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.util.StatusProvider;
import com.jrockit.mc.core.wizards.IPerformFinishable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class StatusWizardPage
extends WizardPage
implements IPerformFinishable {
    private final StatusProvider m_statusProvider = new StatusProvider();
    private final IStatusListener m_statusListener = new WizardPageStatusListener();
    private final Object m_configurationObject;

    public StatusWizardPage(Object configurationObject) {
        super("properties");
        this.setImageDescriptor(ComponentsPlugin.getDefault().getMCImageDescriptor("designLarge.gif"));
        this.m_configurationObject = PersistenceToolkit.createWorkingCopy((Object)configurationObject);
        assert (this.m_configurationObject != null);
    }

    protected abstract String createTitle();

    protected abstract Control createControlArea(Composite var1);

    protected final IStatusListener getStatusLIstener() {
        return this.m_statusListener;
    }

    protected final void updateTitle() {
        this.getShell().setText(this.createTitle());
    }

    protected final StatusProvider getStatusProvider() {
        return this.m_statusProvider;
    }

    protected final Object getConfigurationObject() {
        return this.m_configurationObject;
    }

    public void createControl(Composite parent) {
        this.setTitle(this.createTitle());
        this.setDefaultMessage();
        Control area = this.createControlArea(parent);
        this.setControl(area);
        this.hookWizardStatusListener();
    }

    protected void hookWizardStatusListener() {
        this.m_statusProvider.addStatusListener(this.m_statusListener);
        IStatus status = this.m_statusProvider.getStatus();
        this.setPageComplete(status.getSeverity() != 4);
    }

    protected void setDefaultMessage() {
        this.setErrorMessage(null);
        this.setMessage(Messages.STATUS_WIZARD_MESSAGE_TEXT);
    }

    public boolean performFinish() {
        PersistenceToolkit.commit((Object)this.m_configurationObject);
        return true;
    }

    final class WizardPageStatusListener
    implements IStatusListener {
        WizardPageStatusListener() {
        }

        public void onChange(IStatus statusChangeNotification) {
            IStatus status = StatusWizardPage.this.m_statusProvider.getStatus();
            int errorCount = this.getErrorCount(status);
            if (errorCount == 0) {
                StatusWizardPage.this.setDefaultMessage();
                StatusWizardPage.this.setPageComplete(true);
            } else {
                StatusWizardPage.this.setMessage(null);
                StatusWizardPage.this.setErrorMessage(errorCount == 1 ? this.getSingleErrorMessage(status) : Messages.STATUS_WIZARD_SEE_MARKERS_FOR_MORE_INFORMATION_TEXT);
                StatusWizardPage.this.setPageComplete(false);
            }
        }

        int getErrorCount(IStatus status) {
            IStatus[] children = status.getChildren();
            if (children.length > 0) {
                int errorCount = 0;
                int n = 0;
                while (n < children.length) {
                    errorCount += this.getErrorCount(children[n]);
                    ++n;
                }
                return errorCount;
            }
            return status.getSeverity() == 4 ? 1 : 0;
        }

        String getSingleErrorMessage(IStatus status) {
            if (status.getChildren().length > 0) {
                IStatus[] children = status.getChildren();
                int n = 0;
                while (n < children.length) {
                    String message = this.getSingleErrorMessage(children[n]);
                    if (message != null) {
                        return message;
                    }
                    ++n;
                }
                return null;
            }
            return status.getSeverity() == 4 ? status.getMessage() : null;
        }
    }
}

