/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.behaviors.IStatusListener;
import com.jrockit.mc.components.ui.behaviors.IStatusProvider;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.IMasterDetailFactory;
import com.jrockit.mc.components.ui.settings.InputPanel;
import com.jrockit.mc.components.ui.util.StatusProvider;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterDetailInput
extends Composite
implements IStatusProvider {
    private final IMasterDetailFactory m_masterDetailFactory;
    private final StatusProvider m_statusProvider = new StatusProvider();
    private List<Object> m_detailList;
    private List<IInput> m_mainList;
    private List<IInput> m_specific;
    private InputPanel m_detailPanel;
    private StructuredViewer m_tableViewer;
    private Button m_addButton;
    private Button m_removeButton;
    private Button m_upButton;
    private Button m_downButton;
    private IInput m_baseInput;
    private Setting m_setting;
    private Setting m_specificSetting;

    public MasterDetailInput(Composite parent, Setting setting, IMasterDetailFactory mdf) {
        this(parent, setting, null, mdf);
    }

    public MasterDetailInput(Composite parent, Setting setting, Setting specific, IMasterDetailFactory mdf) {
        super(parent, 0);
        this.m_setting = setting;
        this.m_specificSetting = specific;
        this.m_masterDetailFactory = mdf;
        this.m_detailList = mdf.createDetailList();
        this.m_mainList = mdf.createMainInputs();
        this.m_specific = mdf.createSpecific();
        this.create(this, setting);
        this.m_tableViewer.setInput(this.getDetailList());
        this.updateButtons();
    }

    private List<Object> getDetailList() {
        return this.m_detailList;
    }

    private boolean hasTwoFolders() {
        return !this.m_mainList.isEmpty() || !this.m_specific.isEmpty();
    }

    private void create(Composite parent, Setting setting) {
        if (this.hasTwoFolders()) {
            TabFolder folder = new TabFolder(parent, 0);
            folder.setLayoutData((Object)new GridData(4, 4, true, true));
            TabItem ti1 = new TabItem(folder, 0);
            ti1.setControl(this.createMainInputPanel((Composite)folder, setting).getControl());
            ti1.setText(Messages.MASTER_DEATIL_INPUT_GENERAL_TITLE);
            TabItem ti2 = new TabItem(folder, 0);
            ti2.setControl((Control)this.createTable((Composite)folder));
            ti2.setText(this.m_masterDetailFactory.createMasterTableTitle());
            if (this.m_specific != null && !this.m_specific.isEmpty() && this.m_specificSetting != null) {
                TabItem ti3 = new TabItem(folder, 0);
                ti3.setControl(this.createSpecific(folder, this.m_specificSetting));
                ti3.setText(this.m_masterDetailFactory.createSpecificTitle());
            }
        } else {
            GridData gd2 = new GridData(4, 4, true, true);
            Group group = new Group(parent, 0);
            group.setText(this.m_masterDetailFactory.createMasterTableTitle());
            group.setLayoutData((Object)gd2);
            group.setLayout((Layout)new GridLayout());
            GridData gd3 = new GridData(4, 4, true, true);
            Composite tablePanel = this.createTable((Composite)group);
            tablePanel.setLayoutData((Object)gd3);
        }
        this.setLayout((Layout)new GridLayout());
    }

    private Control createSpecific(TabFolder folder, Setting setting) {
        InputPanel inputPanel = new InputPanel((Composite)folder, setting, this.m_specific);
        this.m_statusProvider.addStatusProvider(inputPanel);
        return inputPanel.getControl();
    }

    private Composite createTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        InputPanel panel = this.createBaseInputPanel(container);
        if (panel != null) {
            GridData gd2 = new GridData(4, 4, true, false);
            gd2.horizontalSpan = 2;
            panel.getControl().setLayoutData((Object)gd2);
        }
        GridData gd1 = new GridData(4, 4, true, false);
        gd1.heightHint = 70;
        Control viewerControl = this.createViewer(container);
        viewerControl.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, false, false);
        Composite buttonPanel = this.createButtonPanel(container);
        buttonPanel.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.horizontalSpan = 2;
        this.m_detailPanel = this.createDetails(container);
        this.m_detailPanel.getControl().setLayoutData((Object)gd3);
        return container;
    }

    private InputPanel createBaseInputPanel(Composite parent) {
        this.m_baseInput = this.m_masterDetailFactory.createDetailBaseInput(parent.getShell());
        if (this.m_baseInput != null) {
            InputPanel ip = new InputPanel(parent, this.m_setting, Arrays.asList(this.m_baseInput));
            this.m_baseInput.addStatusListener(new IStatusListener(){

                public void onChange(IStatus status) {
                    MasterDetailInput.this.m_tableViewer.refresh();
                }
            });
            this.m_statusProvider.addStatusProvider(this.m_baseInput);
            return ip;
        }
        return null;
    }

    private InputPanel createDetails(Composite parent) {
        InputPanel inputPanel = new InputPanel(parent, null, this.m_masterDetailFactory.createDetailInput());
        inputPanel.addStatusListener(new IStatusListener(){

            public void onChange(IStatus status) {
                if (status.getSeverity() == 1) {
                    MasterDetailInput.this.m_tableViewer.refresh();
                }
                MasterDetailInput.this.m_statusProvider.fireChange(status);
            }
        });
        return inputPanel;
    }

    private Composite createButtonPanel(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridData gd1 = new GridData(4, 4, false, false);
        this.m_addButton = this.createAddButton(container);
        this.m_addButton.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, false, false);
        this.m_removeButton = this.createRemoveButton(container);
        this.m_removeButton.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, false, false);
        this.m_upButton = this.createMoveButton(container, Messages.MASTER_DETAIL_INPUT_MOVE_UP_BUTTON_TEXT, -1);
        this.m_upButton.setLayoutData((Object)gd3);
        GridData gd4 = new GridData(4, 4, false, false);
        this.m_downButton = this.createMoveButton(container, Messages.MASTER_DETAIL_INPUT_MOVE_DOWN_BUTTON_TEXT, 1);
        this.m_downButton.setLayoutData((Object)gd4);
        return container;
    }

    private Button createMoveButton(Composite parent, String text, final int delta) {
        Button button = new Button(parent, 0);
        button.setText(text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = MasterDetailInput.this.getDetailList().indexOf(MasterDetailInput.this.getSelected());
                Collections.swap(MasterDetailInput.this.getDetailList(), index, index + delta);
                MasterDetailInput.this.m_tableViewer.refresh();
                MasterDetailInput.this.updateButtons();
            }
        });
        return button;
    }

    private void updateButtons() {
        int selectedIndex = this.getSelectedIndex();
        this.updateUpButton(selectedIndex);
        this.updateDownButton(selectedIndex);
        this.updateRemoveButton(selectedIndex);
    }

    private int getSelectedIndex() {
        Object selected = this.getSelected();
        if (selected != null) {
            return this.getDetailList().indexOf(selected);
        }
        return -1;
    }

    private void updateRemoveButton(int index) {
        this.m_removeButton.setEnabled(index != -1);
    }

    private void updateDownButton(int index) {
        this.m_downButton.setEnabled(index != -1 && index < this.getDetailList().size() - 1);
    }

    private void updateUpButton(int index) {
        this.m_upButton.setEnabled(index > 0);
    }

    private Button createRemoveButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.MASTER_DETAIL_INPUT_REMOVE_BUTTON_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MasterDetailInput.this.removeSelected();
            }
        });
        return button;
    }

    private Button createAddButton(final Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.MASTER_DETAIL_INPUT_ADD_BUTTON_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MasterDetailInput.this.add(parent.getShell());
            }
        });
        return button;
    }

    private void add(Shell shell) {
        final List<Object> list = this.m_masterDetailFactory.createNew(shell);
        if (list != null && !list.isEmpty()) {
            this.getDetailList().addAll(list);
            this.m_tableViewer.setInput(this.getDetailList());
            this.m_detailPanel.setSetting(PersistenceToolkit.getSetting((Object)list.get(0)));
            this.updateButtons();
            DisplayToolkit.safeAsyncExec((Widget)shell, (Runnable)new Runnable(){

                public void run() {
                    MasterDetailInput.this.m_tableViewer.setSelection((ISelection)new StructuredSelection(list.get(0)));
                }
            });
        }
    }

    private Object getSelected() {
        IStructuredSelection ss = (IStructuredSelection)this.m_tableViewer.getSelection();
        if (!ss.isEmpty()) {
            return ss.getFirstElement();
        }
        return null;
    }

    private InputPanel createMainInputPanel(Composite parent, Setting setting) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        InputPanel ip = new InputPanel(parent, setting, this.m_mainList);
        ip.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_statusProvider.addStatusProvider(ip);
        return ip;
    }

    private Control createViewer(Composite parent) {
        this.m_tableViewer = this.m_masterDetailFactory.createTableViewer(parent);
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object = MasterDetailInput.this.getSelected();
                if (object != null) {
                    Setting setting = PersistenceToolkit.getSetting((Object)object);
                    MasterDetailInput.this.m_detailPanel.setSetting(setting);
                } else {
                    MasterDetailInput.this.m_detailPanel.setSetting(null);
                }
                MasterDetailInput.this.updateButtons();
            }
        });
        return this.m_tableViewer.getControl();
    }

    @Override
    public void addStatusListener(IStatusListener listener) {
        this.m_statusProvider.addStatusListener(listener);
    }

    @Override
    public IStatus getStatus() {
        return this.m_statusProvider.getStatus();
    }

    @Override
    public void removeStatusListener(IStatusListener listener) {
        this.m_statusProvider.removeStatusListener(listener);
    }

    private void removeSelected() {
        Object selected = this.getSelected();
        if (selected != null) {
            this.getDetailList().remove(selected);
            this.m_tableViewer.setInput(this.getDetailList());
        } else {
            this.m_detailPanel.setSetting(null);
        }
    }
}

