/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.CompositeInput;
import com.jrockit.mc.components.ui.settings.IInput;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputPanel
extends CompositeInput {
    private static final int MARGIN_RIGHT = 10;
    private final Composite m_container;

    public InputPanel(Composite parent, Object object, List<IInput> children) {
        for (IInput i : children) {
            this.addInput(i);
        }
        this.m_container = new Composite(parent, 0);
        Composite booleanInputCntainer = new Composite(this.m_container, 0);
        int inputCount = this.createBooleans(booleanInputCntainer);
        booleanInputCntainer.setLayoutData((Object)new GridData(1, 4, false, false));
        booleanInputCntainer.setLayout((Layout)this.createLayout(2 * inputCount));
        Composite standardInputContainer = new Composite(this.m_container, 0);
        standardInputContainer.setLayout((Layout)this.createLayout(4));
        standardInputContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createStandard(standardInputContainer, 4);
        this.setSetting(this.getSetting(object));
        this.hookDisposeListener(this.m_container);
        this.m_container.setLayout((Layout)this.createMainLayout());
    }

    private GridLayout createMainLayout() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        return layout;
    }

    private GridLayout createLayout(int count) {
        GridLayout layout = new GridLayout(count, false);
        layout.marginRight = 10;
        layout.marginLeft = 0;
        return layout;
    }

    public int createBooleans(Composite parent) {
        int count = 0;
        for (IInput input : this.getInputs()) {
            if (!(input instanceof BooleanInput)) continue;
            input.create(parent, 1);
            ++count;
        }
        return count;
    }

    @Override
    public void create(Composite parent, int horizontalSpan) {
        throw new UnsupportedOperationException();
    }

    public void createStandard(Composite parent, int horizontalSpan) {
        for (IInput input : this.getInputs()) {
            if (input instanceof BooleanInput) continue;
            input.create(parent, horizontalSpan);
        }
    }

    private Setting getSetting(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Setting) {
            return (Setting)object;
        }
        return PersistenceToolkit.getSetting((Object)object);
    }

    private void hookDisposeListener(Composite composite) {
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                InputPanel.this.dispose();
            }
        });
    }

    public final Control getControl() {
        return this.m_container;
    }
}

