/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.util.StatusProvider;

public abstract class Input
extends StatusProvider
implements IInput {
    private final String m_key;
    private final String m_name;
    private Setting m_setting;
    private boolean m_inRefresh;
    private String m_domain;

    public Input(String key, String name) {
        this.m_key = key;
        this.m_name = name;
    }

    public abstract void refresh();

    protected void markStale() {
        if (!this.m_inRefresh) {
            this.m_inRefresh = true;
            this.refresh();
            this.m_inRefresh = false;
            this.fireChange(IInput.STATUS_SETTING_CHANGE);
            this.fireChange(this.getStatus());
        }
    }

    protected final String getKey() {
        return this.m_key;
    }

    protected final String getName() {
        return this.m_name;
    }

    protected final Setting getSetting() {
        return this.m_setting;
    }

    public void setSetting(Setting setting) {
        this.m_setting = setting;
        this.refresh();
    }

    public void dispose() {
        this.clear();
    }

    protected String getPropertyValue() {
        return (String)this.m_setting.getChildObject(this.m_key, String.class);
    }

    protected void setPropertyValue(String value) {
        this.m_setting.setChildObject(this.m_key, (Object)value);
    }

    protected boolean isEnabled() {
        return this.m_setting != null;
    }

    public final void setDomain(String domain) {
        this.m_domain = domain;
    }

    protected final String getDomain() {
        return this.m_domain;
    }
}

