/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.settings.IconEditor;
import com.jrockit.mc.components.ui.settings.Input;
import com.jrockit.mc.components.ui.tab.ImageConverter;
import com.jrockit.mc.components.ui.util.ImageDescriptor;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class IconInput
extends Input {
    private static final int MARGIN = 5;
    private static final int CLEAR_BUTTON_SPAN = 1;
    private int m_size = 16;
    private boolean m_allowClear = true;
    private Image m_image;
    private Label m_icon;
    private Button m_editButton;

    public IconInput(String property, String name) {
        super(property, name);
    }

    public void setAllowClear(boolean allow) {
        this.m_allowClear = allow;
    }

    public void setSize(int size) {
        this.m_size = size;
    }

    public boolean getAllowClear() {
        return this.m_allowClear;
    }

    public int getSize() {
        return this.m_size;
    }

    public void create(Composite parent, int horizontalSpan) {
        GridData gd1 = new GridData(4, 4, false, false);
        gd1.horizontalSpan = 1;
        Label label = new Label(parent, 0);
        label.setText(this.getName());
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        gd2.widthHint = this.m_size + 5;
        gd2.heightHint = this.m_size + 5;
        gd2.horizontalSpan = this.calculateIconlSpan(horizontalSpan);
        this.m_icon = new Label(parent, 2048);
        this.m_icon.setLayoutData((Object)gd2);
        this.m_icon.setAlignment(0x1000000);
        GridData gd3 = new GridData(4, 1, false, false);
        gd3.horizontalSpan = 2;
        this.m_editButton = this.createEditButton(parent);
        this.m_editButton.setLayoutData((Object)gd3);
        if (this.getAllowClear()) {
            GridData gd4 = new GridData(4, 1, false, false);
            gd3.horizontalSpan = 1;
            this.m_editButton = this.createClearButton(parent);
            this.m_editButton.setLayoutData((Object)gd4);
        }
    }

    private int calculateIconlSpan(int horizontalSpan) {
        if (this.m_allowClear) {
            --horizontalSpan;
        }
        return horizontalSpan - 1 - 2;
    }

    private Button createClearButton(Composite parent) {
        Button browseButton = new Button(parent, 0);
        browseButton.setText("Clear");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IconInput.this.clearIcon();
            }
        });
        return browseButton;
    }

    private Button createEditButton(final Composite parent) {
        Button browseButton = new Button(parent, 0);
        browseButton.setText(Messages.ICON_INPUT_BROWSE_BUTTON_TEXT);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IconInput.this.showIconEditor(parent.getShell());
            }
        });
        return browseButton;
    }

    private void showIconEditor(Shell shell) {
        ImageDescriptor imageDescriptor = this.getImageDescriptor();
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.createWithSize(this.m_size, this.m_size);
        }
        IconEditor ice = new IconEditor(imageDescriptor);
        OnePageWizardDialog dialog = new OnePageWizardDialog(shell, (IWizardPage)ice);
        dialog.setWidthConstaint(400, 400);
        dialog.setHeightConstraint(600, 600);
        if (dialog.open() == 0) {
            this.getSetting().setChildObject(this.getKey(), (Object)ice.getImageDescriptor());
            this.refresh();
        }
    }

    public void refresh() {
        this.m_editButton.setEnabled(this.isEnabled());
        this.m_icon.setEnabled(this.isEnabled());
        this.destroyImage();
        if (this.isEnabled() && this.getImageDescriptor() != null) {
            this.m_image = ImageConverter.createImage((Device)this.m_icon.getDisplay(), this.getImageDescriptor());
        }
        this.m_icon.setImage(this.m_image);
    }

    private ImageDescriptor getImageDescriptor() {
        if (this.getSetting().hasChild(this.getKey())) {
            return (ImageDescriptor)this.getSetting().getChildObject(this.getKey(), ImageDescriptor.class);
        }
        return null;
    }

    private void destroyImage() {
        if (this.m_image != null && !this.m_image.isDisposed()) {
            this.m_image.dispose();
            this.m_image = null;
        }
    }

    public void dispose() {
        this.destroyImage();
        super.dispose();
    }

    public String getErrorText() {
        Image image = null;
        try {
            if (this.getImageDescriptor() != null && (image = ImageConverter.createImage((Device)this.m_icon.getDisplay(), this.getImageDescriptor())) == null) {
                String string = Messages.ICON_INPUT_MUST_SELECT_VALID_IMAGE_FILE_ERROR_TEXT;
                return string;
            }
            return null;
        }
        finally {
            if (image != null) {
                image.dispose();
            }
        }
    }

    private void clearIcon() {
        this.getSetting().setChildObject(this.getKey(), null);
        this.markStale();
    }
}

