/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.tab.ImageConverter;
import com.jrockit.mc.components.ui.util.ImageDescriptor;
import com.jrockit.mc.core.misc.MCColor;
import com.jrockit.mc.core.wizards.IPerformFinishable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class IconEditor
extends WizardPage
implements IPerformFinishable {
    private static final MCColor LIGHT_GREY = new MCColor(250, 250, 250);
    private static final MCColor DARK_GREY = new MCColor(192, 192, 192);
    private ImageDescriptor m_imageDescriptor;
    private final MCColor m_currentDrawingColor = new MCColor();
    private boolean m_drawing;
    private Canvas m_drawingArea;
    private Text m_colorLabel;
    private Color m_color;
    private Image m_image;
    private Image m_backgroundImage;

    public IconEditor(ImageDescriptor sourceImageDescriptor) {
        super("iconEditor");
        this.setTitle(Messages.ICON_EDITOR_TITLE);
        this.m_imageDescriptor = sourceImageDescriptor;
    }

    public void createControl(Composite parent) {
        this.m_image = ImageConverter.createImage((Device)parent.getDisplay(), this.m_imageDescriptor);
        this.setDescription(Messages.ICON_EDITOR_DESCRIPTION_TEXT);
        Composite container = new Composite(parent, 2048);
        container.setLayout((Layout)new GridLayout(4, false));
        GridData gd1 = new GridData(4, 4, false, false);
        Button check = this.createTransparentCheckBox(container);
        check.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        this.m_colorLabel = this.createColorLabel(container);
        this.m_colorLabel.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, false, false);
        Button pickerButton = this.createColorPickerButton(container);
        pickerButton.setLayoutData((Object)gd3);
        GridData gd4 = new GridData(4, 4, false, false);
        Button browseButton = this.createBrowseButton(container);
        browseButton.setLayoutData((Object)gd4);
        GridData gd5 = new GridData(4, 4, true, true);
        gd5.horizontalSpan = 4;
        this.m_drawingArea = this.createDrawingArea(container);
        this.m_drawingArea.setLayoutData((Object)gd5);
        this.updatColorLabel();
        this.updateImage((Device)container.getDisplay());
        this.updateBackgroundImage(container.getDisplay());
        this.setControl((Control)container);
    }

    private void updateImage(Device device) {
        if (this.m_image != null) {
            this.m_image.dispose();
        }
        this.m_image = ImageConverter.createImage(device, this.m_imageDescriptor);
        this.m_drawingArea.redraw();
        this.m_drawingArea.update();
    }

    void updateBackgroundImage(Display display) {
        if (this.m_backgroundImage != null) {
            this.m_backgroundImage.dispose();
        }
        int width = 2 * this.m_imageDescriptor.getWidth();
        int height = 2 * this.m_imageDescriptor.getHeight();
        Image i = new Image((Device)display, width, height);
        ImageData id = i.getImageData();
        int lightPixelColor = id.palette.getPixel(LIGHT_GREY.getRGBColor());
        int darkPixelColor = id.palette.getPixel(DARK_GREY.getRGBColor());
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                id.setPixel(x, y, (x + y) % 2 == 0 ? lightPixelColor : darkPixelColor);
                ++x;
            }
            ++y;
        }
        this.m_backgroundImage = new Image((Device)display, id);
    }

    private Canvas createDrawingArea(Composite container) {
        Canvas canvas = new Canvas(container, 0x20000800);
        this.hookPaintListener(canvas);
        this.hookMouseListeners(canvas);
        return canvas;
    }

    private void hookPaintListener(Canvas canvas) {
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                IconEditor.this.paintImage(e.display, e.gc);
            }
        });
    }

    private void hookMouseListeners(final Canvas canvas) {
        canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IconEditor.this.m_drawing = true;
                IconEditor.this.putPixel(canvas.getDisplay(), e.x, e.y);
            }

            public void mouseUp(MouseEvent e) {
                IconEditor.this.m_drawing = false;
            }
        });
        canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (IconEditor.this.m_drawing) {
                    IconEditor.this.putPixel(canvas.getDisplay(), e.x, e.y);
                }
            }
        });
    }

    void putPixel(Display display, int x, int y) {
        this.setPixel(this.convertXDeviceToWorld(x), this.convertYDeviceToWorld(y), this.m_currentDrawingColor);
        this.updateImage((Device)display);
    }

    private void setPixel(int x, int y, MCColor color) {
        if (x >= 0 && y >= 0 && x < this.m_imageDescriptor.getWidth() && y < this.m_imageDescriptor.getHeight()) {
            PaletteData palette = this.m_image.getImageData().palette;
            ImageData imageData = this.m_image.getImageData();
            imageData.setPixel(x, y, palette.getPixel(color.getRGBColor()));
            imageData.setAlpha(x, y, color.getAlpha());
            Image image = new Image((Device)this.m_drawingArea.getDisplay(), imageData);
            this.m_imageDescriptor = ImageConverter.createImageDescriptor(image);
            image.dispose();
        }
    }

    private Button createBrowseButton(final Composite parent) {
        Button browseButton = new Button(parent, 0);
        browseButton.setText(Messages.ICON_EDITOR_BROWSE_BUTTON_TEXT);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IconEditor.this.showFileDialog(parent.getShell());
            }
        });
        return browseButton;
    }

    private void showFileDialog(Shell shell) {
        FileDialog fd = new FileDialog(shell, 4096);
        String fileName = fd.open();
        if (fileName != null) {
            this.setIcon(shell.getDisplay(), fileName);
        }
    }

    private void setIcon(Display display, String fileName) {
        try {
            Image image = new Image((Device)display, (InputStream)new FileInputStream(fileName));
            this.m_imageDescriptor = ImageConverter.createImageDescriptor(image);
            image.dispose();
            this.updateImage((Device)display);
            this.updateBackgroundImage(display);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(Messages.ICON_INPUT_COULD_NOT_LOAD_IMAGE_ERROR_TEXT, e);
        }
    }

    private Button createColorPickerButton(Composite container) {
        final Button b = new Button(container, 0);
        b.setText(Messages.ICON_EDITOR_EDIT_COLOR_BUTTON_TEXT);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(b.getShell());
                RGB color = cd.open();
                if (color != null) {
                    IconEditor.this.m_currentDrawingColor.setRGB(color);
                    IconEditor.this.updatColorLabel();
                }
            }
        });
        return b;
    }

    private Text createColorLabel(Composite container) {
        Text l = new Text(container, 2056);
        return l;
    }

    private void updatColorLabel() {
        if (this.m_color != null) {
            this.m_color.dispose();
        }
        this.m_color = this.m_currentDrawingColor.createSWTColor((Device)this.m_colorLabel.getDisplay());
        this.m_colorLabel.setBackground(this.m_color);
    }

    private int convertXDeviceToWorld(int x) {
        double normalizedX = (double)x / (double)this.m_drawingArea.getClientArea().width;
        return (int)((double)this.m_imageDescriptor.getWidth() * normalizedX);
    }

    private int convertYDeviceToWorld(int y) {
        double normalizedY = (double)y / (double)this.m_drawingArea.getClientArea().height;
        return (int)((double)this.m_imageDescriptor.getHeight() * normalizedY);
    }

    private Button createTransparentCheckBox(Composite container) {
        final Button checkBox = new Button(container, 32);
        checkBox.setText(Messages.ICON_EDITOR_TRANSPARENT_TEXT);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IconEditor.this.m_currentDrawingColor.setAlpha(checkBox.getSelection() ? 0 : 255);
            }
        });
        return checkBox;
    }

    private void paintImage(Display display, GC gc) {
        int drawingWidth = this.m_drawingArea.getClientArea().width;
        int drawingHeight = this.m_drawingArea.getClientArea().height;
        this.drawBackgroundImage(gc, drawingWidth, drawingHeight);
        this.drawImage(gc, drawingWidth, drawingHeight);
    }

    private void drawImage(GC gc, int drawingWidth, int drawingHeight) {
        gc.drawImage(this.m_image, 0, 0, this.m_imageDescriptor.getWidth(), this.m_imageDescriptor.getHeight(), 0, 0, drawingWidth, drawingHeight);
    }

    private void drawBackgroundImage(GC gc, int drawingWidth, int drawingHeight) {
        gc.drawImage(this.m_backgroundImage, 0, 0, 2 * this.m_imageDescriptor.getWidth(), 2 * this.m_imageDescriptor.getHeight(), 0, 0, drawingWidth, drawingHeight);
    }

    public void dispose() {
        if (this.m_color != null) {
            this.m_color.dispose();
        }
        if (this.m_image != null) {
            this.m_image.dispose();
        }
        if (this.m_backgroundImage != null) {
            this.m_backgroundImage.dispose();
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return this.m_imageDescriptor;
    }

    public boolean performFinish() {
        this.dispose();
        return true;
    }
}

