/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.util.StatusProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompositeInput
extends StatusProvider
implements IInput {
    private final List<IInput> m_inputs = new ArrayList<IInput>();

    CompositeInput() {
    }

    public void addInput(IInput input) {
        this.m_inputs.add(input);
        this.addStatusProvider(input);
    }

    public void removeInput(IInput input) {
        this.m_inputs.remove(input);
        this.removeStatusProvider(input);
    }

    public List<IInput> getInputs() {
        return Collections.unmodifiableList(this.m_inputs);
    }

    @Override
    public void setSetting(Setting setting) {
        for (IInput input : this.getInputs()) {
            input.setSetting(setting);
        }
        this.refresh();
    }

    @Override
    public void refresh() {
        for (IInput input : this.getInputs()) {
            input.refresh();
        }
    }

    @Override
    public void create(Composite parent, int horizontalSpan) {
        for (IInput input : this.getInputs()) {
            input.create(parent, horizontalSpan);
        }
    }

    @Override
    public void dispose() {
        for (IInput input : this.getInputs()) {
            input.dispose();
        }
        this.clear();
    }
}

