/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.behaviors.IConfigurer;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeRegistry;
import com.jrockit.mc.components.ui.design.view.components.ComponentDescriptorWizardPage;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.Input;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ComponentDescriptorInput
extends Input {
    private final IServiceLocator m_serviceLocator;
    private Button m_button;

    public ComponentDescriptorInput(IServiceLocator locator, String key, String name) {
        super(key, name);
        this.m_serviceLocator = locator;
    }

    public void refresh() {
        this.m_button.setEnabled(this.isEnabled());
    }

    public void create(Composite parent, int horizontalSpan) {
        GridData gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = horizontalSpan;
        this.m_button = this.createButton(parent);
        this.m_button.setLayoutData((Object)gd);
    }

    private Button createButton(Composite parent) {
        final Button button = new Button(parent, 0);
        button.setText(Messages.COMPONENT_DESCRIPTOR_INPUT_CONFIGURATION_BUTTON_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentDescriptorInput.this.editComponent(button.getShell());
            }
        });
        return button;
    }

    protected void editComponent(Shell shell) {
        ComponentDescriptor cd = (ComponentDescriptor)this.getSetting().getChildObject(this.getKey(), ComponentDescriptor.class);
        if (cd != null) {
            this.configureComponentDescriptor(shell, cd);
        }
    }

    private void configureComponentDescriptor(Shell shell, ComponentDescriptor cd) {
        ComponentTypeRegistry ctr = ComponentsPlugin.getDefault().getComponentTypeRegistry();
        IConfigurer configurer = ctr.createConfigurer(cd);
        if (configurer != null) {
            ComponentDescriptorWizardPage cw = new ComponentDescriptorWizardPage(configurer, this.m_serviceLocator, cd, true);
            OnePageWizardDialog owd = new OnePageWizardDialog(shell, (IWizardPage)cw);
            owd.setWidthConstaint(300, 700);
            owd.setHeightConstraint(500, Integer.MAX_VALUE);
            ComponentTypeDescriptor ctDescriptor = ctr.getComponentTypeDescriptor(cd.getTypeIdentifier());
            owd.setImage(ctDescriptor.getIcon());
            owd.open();
        }
    }
}

