/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.settings.Input;
import com.jrockit.mc.core.misc.MCColor;
import java.awt.Color;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class ColorInput
extends Input {
    private static final MCColor GRAY = new MCColor(Color.GRAY);
    private static final MCColor WHITE = new MCColor(Color.WHITE);
    private static final MCColor BLACK = new MCColor(Color.BLACK);
    private Text m_text;
    private org.eclipse.swt.graphics.Color m_backGroundColor;
    private org.eclipse.swt.graphics.Color m_foreGroundColor;
    private Button m_browseButton;

    public ColorInput(String childName, String name) {
        super(childName, name);
    }

    public void create(Composite parent, int horizontalSpan) {
        GridData gd1 = new GridData(4, 4, false, false);
        gd1.verticalAlignment = 0x1000000;
        gd1.horizontalSpan = 1;
        Label label = new Label(parent, 0);
        label.setText(this.getName());
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.verticalAlignment = 0x1000000;
        gd2.horizontalSpan = horizontalSpan - 2 - 1;
        this.m_text = new Text(parent, 2056);
        this.m_text.setText("");
        this.m_text.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, false, false);
        gd3.horizontalSpan = 2;
        this.m_browseButton = this.createBrowseButton(parent, this.m_text);
        this.m_browseButton.setLayoutData((Object)gd3);
    }

    private Button createBrowseButton(final Composite parent, Text text) {
        Button button = new Button(parent, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorInput.this.selectNewColor(parent.getShell());
            }
        });
        button.setText(Messages.COLOR_INPUT_SELECT_BUTTON_TEXT);
        return button;
    }

    private MCColor getColor() {
        return (MCColor)this.getSetting().getChildObject(this.getKey(), MCColor.class);
    }

    private void setColor(MCColor color) {
        this.getSetting().setChildObject(this.getKey(), (Object)color);
    }

    private void selectNewColor(Shell shell) {
        ColorDialog cd = new ColorDialog(shell, 0);
        cd.setRGB(this.getColor().getRGBColor());
        RGB rgb = cd.open();
        if (rgb != null) {
            this.setColor(new MCColor(rgb));
            this.markStale();
        }
    }

    private String humanReadable(MCColor color) {
        return "RGB = { " + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + " }";
    }

    private void destroyColors() {
        this.destroyColor(this.m_foreGroundColor);
        this.destroyColor(this.m_backGroundColor);
    }

    private void destroyColor(org.eclipse.swt.graphics.Color color) {
        if (color != null && !color.isDisposed()) {
            color.dispose();
        }
    }

    public void refresh() {
        this.m_browseButton.setEnabled(this.isEnabled());
        this.m_text.setEnabled(this.isEnabled());
        if (this.isEnabled()) {
            this.destroyColors();
            this.m_backGroundColor = new org.eclipse.swt.graphics.Color((Device)this.m_text.getDisplay(), this.getColor().getRGBColor());
            this.m_foreGroundColor = new org.eclipse.swt.graphics.Color((Device)this.m_text.getDisplay(), ColorInput.createReadableComplement(this.getColor()).getRGBColor());
            this.m_text.setBackground(this.m_backGroundColor);
            this.m_text.setForeground(this.m_foreGroundColor);
            this.m_text.setText(this.humanReadable(this.getColor()));
        } else {
            this.m_text.setBackground(this.m_text.getDisplay().getSystemColor(22));
            this.m_text.setForeground(this.m_text.getDisplay().getSystemColor(21));
            this.m_text.setText("");
        }
    }

    private static MCColor createReadableComplement(MCColor color) {
        if (color.getRed() + color.getBlue() + color.getGreen() < GRAY.getRed() + GRAY.getGreen() + GRAY.getBlue()) {
            return WHITE;
        }
        return BLACK;
    }

    protected void disposes() {
        this.destroyColors();
        super.dispose();
    }
}

