/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.components.ui.settings.Input;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class BooleanInput
extends Input {
    private Button m_button;

    public BooleanInput(String property, String name) {
        super(property, name);
    }

    public final void create(Composite parent, int horizontalSpan) {
        GridData gd2 = new GridData(4, 4, true, false);
        gd2.horizontalSpan = horizontalSpan;
        if (horizontalSpan > 1) {
            GridData gd1 = new GridData(4, 4, false, false);
            gd1.horizontalSpan = 1;
            gd1.verticalAlignment = 0x1000000;
            Label label = this.createLabel(parent);
            label.setLayoutData((Object)gd1);
            --gd2.horizontalSpan;
        }
        this.m_button = this.createCheckBox(parent, horizontalSpan);
        this.m_button.setLayoutData((Object)gd2);
    }

    public final void refresh() {
        this.m_button.setEnabled(this.isEnabled());
        if (this.isEnabled()) {
            this.m_button.setSelection(Boolean.TRUE.toString().equals(this.getPropertyValue()));
        }
    }

    protected void onCheckClick(boolean check) {
        this.setPropertyValue(Boolean.toString(check));
        this.markStale();
    }

    protected final Button createCheckBox(Composite parent, int horizontalSpan) {
        Button checkBoxButton = new Button(parent, 32);
        if (horizontalSpan == 1) {
            checkBoxButton.setText(this.getName());
        }
        checkBoxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BooleanInput.this.onCheckClick(BooleanInput.this.m_button.getSelection());
            }
        });
        return checkBoxButton;
    }

    private Label createLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.getName());
        return label;
    }
}

