/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.services;

import com.jrockit.mc.components.ui.behaviors.IComponent;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceLocator
implements IServiceLocator {
    private final Map<String, Object> m_serviceMap = new LinkedHashMap<String, Object>();
    private final List<IServiceLocator> m_children = new ArrayList<IServiceLocator>();
    private final ServiceLocator m_parent;
    private final Object m_monitor = new Object();

    public ServiceLocator(ServiceLocator parent) {
        this.m_parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IServiceLocator createChildService() {
        ServiceLocator locator = new ServiceLocator(this);
        Object object = this.m_monitor;
        synchronized (object) {
            this.m_children.add(locator);
            return locator;
        }
    }

    public boolean registerService(Class api, Object serviceInstance) {
        return this.registerService(api.getName(), serviceInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerService(String name, Object service) {
        Object object = this.m_monitor;
        synchronized (object) {
            block5: {
                if (this.m_serviceMap.containsKey(name)) break block5;
                if (service instanceof IComponent) {
                    ((IComponent)service).initialize(this);
                }
                this.m_serviceMap.put(name, service);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getService(String name) {
        IServiceLocator parent;
        Object o = null;
        Object object = this.m_monitor;
        synchronized (object) {
            o = this.m_serviceMap.get(name);
        }
        if (o == null && (parent = this.getParent()) != null) {
            o = parent.getService(name);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.m_monitor;
        synchronized (object) {
            IServiceLocator[] children = this.getChildren();
            int n = 0;
            while (n < children.length) {
                children[n].dispose();
                ++n;
            }
            if (this.m_parent != null) {
                this.m_parent.removeChild(this);
            }
        }
    }

    public <T> T getService(Class<T> serviceClass, String name) {
        return (T)this.getService(name);
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        return (T)this.getService(serviceClass.getName());
    }

    @Override
    public boolean hasService(String name) {
        return this.getService(name) != null;
    }

    public boolean hasService(Class api) {
        return this.hasService(api.getName());
    }

    @Override
    public boolean registerService(Object service) {
        return this.registerService(service.getClass().getName(), service);
    }

    @Override
    public IServiceLocator getParent() {
        return this.m_parent;
    }

    @Override
    public IServiceLocator[] getChildren() {
        return this.m_children.toArray(new IServiceLocator[this.m_children.size()]);
    }

    private void removeChild(ServiceLocator serviceLocator) {
        this.m_children.remove(serviceLocator);
    }

    @Override
    public List<String> getServiceNames() {
        return new ArrayList<String>((Collection)this.m_serviceMap.keySet());
    }

    @Override
    public boolean unregisterService(Object service) {
        if (service instanceof String) {
            this.m_serviceMap.remove(service);
        } else {
            this.m_serviceMap.remove(service.getClass().getName());
        }
        return true;
    }

    @Override
    public void clear() {
        for (Object o : this.m_serviceMap.values()) {
            if (!(o instanceof IComponent)) continue;
            IComponent sl = (IComponent)o;
            sl.dispose(this);
        }
        this.m_children.clear();
    }
}

