/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.sash;

import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptor;
import com.jrockit.mc.components.ui.design.view.components.ComponentTypeWizardPage;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.sash.SashItemContentProvider;
import com.jrockit.mc.components.ui.sash.SashItemDescriptor;
import com.jrockit.mc.components.ui.sash.SashItemRepository;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.ComboInput;
import com.jrockit.mc.components.ui.settings.ComponentDescriptorInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.IMasterDetailFactory;
import com.jrockit.mc.components.ui.settings.IntegerInput;
import com.jrockit.mc.components.ui.settings.Orientation;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.FieldTableViewer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SashMasterDetailFactory
implements IMasterDetailFactory {
    private final Field[] FIELD_PROTOTYPES = new Field[]{SashItemContentProvider.FIELD_NAME, SashItemContentProvider.FIELD_WEIGHT};
    private final SashItemRepository m_sashItemRepository;
    private final IServiceLocator m_serviceLocator;

    SashMasterDetailFactory(SashItemRepository tabFolderItemRepository, IServiceLocator serviceLocator) {
        this.m_sashItemRepository = tabFolderItemRepository;
        this.m_serviceLocator = serviceLocator;
    }

    @Override
    public IInput createDetailBaseInput(Shell shell) {
        return null;
    }

    @Override
    public List<IInput> createDetailInput() {
        ArrayList<IInput> list = new ArrayList<IInput>();
        list.add(new IntegerInput("weight", Messages.SASH_COMPONENT_CONFIGURATIONWEIGHT_TEXT, 1, 1000));
        list.add(new ComponentDescriptorInput(this.m_serviceLocator, "componentDescriptor", Messages.SASH_COMPONENT_CONFIGURATIONCOMPONENT_TEXT));
        return list;
    }

    public List createDetailList() {
        return this.m_sashItemRepository.getSashItems();
    }

    @Override
    public List<IInput> createMainInputs() {
        ArrayList<IInput> mainList = new ArrayList<IInput>();
        mainList.add(this.createOrientation());
        return mainList;
    }

    private IInput createOrientation() {
        ComboInput orientationInput = new ComboInput("orientation", Messages.SASH_COMPONENT_CONFIGURATIONORIENTATION_TEXT);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Orientation.VERTICAL.getKey(), Orientation.VERTICAL.getName());
        map.put(Orientation.HORIZONTAL.getKey(), Orientation.HORIZONTAL.getName());
        orientationInput.setItems(map);
        return orientationInput;
    }

    @Override
    public String createMasterTableTitle() {
        return Messages.SASH_COMPONENT_CONFIGURATIONSASH_ITEMS_ITITLE;
    }

    @Override
    public List<Object> createNew(Shell shell) {
        ComponentDescriptor cd;
        ComponentTypeWizardPage ctwp = new ComponentTypeWizardPage();
        OnePageWizardDialog owd = new OnePageWizardDialog(shell, (IWizardPage)ctwp);
        owd.setWidthConstaint(400, 700);
        owd.setHeightConstraint(300, Integer.MAX_VALUE);
        owd.open();
        ComponentTypeDescriptor ctd = ctwp.getSelected();
        if (ctd != null && (cd = ComponentDescriptor.createNew(ctd)) != null) {
            SashItemDescriptor tid = new SashItemDescriptor();
            tid.setWeight(10);
            tid.setComponentDescriptor(cd);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(tid);
            return list;
        }
        return null;
    }

    @Override
    public StructuredViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 268503812);
        FieldTableViewer tableViewer = new FieldTableViewer(table, this.FIELD_PROTOTYPES);
        tableViewer.setContentProvider((IContentProvider)new SashItemContentProvider());
        tableViewer.setInput((Object)this.m_sashItemRepository);
        return tableViewer;
    }

    @Override
    public List<IInput> createSpecific() {
        return new ArrayList<IInput>();
    }

    @Override
    public String createSpecificTitle() {
        return null;
    }
}

