/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.sash;

import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.design.ComponentHolder;
import com.jrockit.mc.components.ui.design.GUIFactory;
import com.jrockit.mc.components.ui.sash.SashItemDescriptor;
import com.jrockit.mc.components.ui.sash.SashItemRepository;
import com.jrockit.mc.core.accessibility.SimpleTraverseListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class SashComponent
extends AbstractUIComponent {
    public Control createPart(Composite parent) {
        SashForm form = new SashForm(parent, this.getSashItemRepository().getOrientation().toSWTStyle());
        GUIFactory factory = new GUIFactory(this.getServiceLocator());
        form.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        int[] weights = new int[this.getSashItemRepository().getSashItems().size()];
        int weightIndex = 0;
        for (SashItemDescriptor sd : this.getSashItemRepository().getSashItems()) {
            int weight = this.createSash(factory, form, sd);
            if (weight <= 0) continue;
            weights[weightIndex++] = weight;
        }
        form.setWeights(SashComponent.truncate(weights, weightIndex));
        return form;
    }

    private static int[] truncate(int[] source, int newSize) {
        int[] destination = new int[newSize];
        System.arraycopy(source, 0, destination, 0, newSize);
        return destination;
    }

    private int createSash(GUIFactory factory, SashForm parent, SashItemDescriptor sd) {
        ComponentDescriptor cd = sd.getComponentDescriptor();
        if (cd != null) {
            ComponentHolder holder = factory.createDisposableComponent(cd, (Composite)parent);
            if (holder.component != null) {
                factory.addComponentToScope(holder.component);
            }
            return sd.getWeight();
        }
        return -1;
    }

    private SashItemRepository getSashItemRepository() {
        return (SashItemRepository)this.getComponentSettings().getChildObject("sashItemRepository", SashItemRepository.class);
    }
}

