/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.l10n;

import com.jrockit.mc.common.persistence.LocalizedString;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Observable;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalizationModel
extends Observable {
    private final String[] m_allLocales = this.createAllLocales();
    private final Object m_object;
    private final List<LocalizedString> m_strings;
    private List<String> m_usedLocales;
    private Set<String> m_duplicateKeys;

    LocalizationModel(Object object) {
        this.m_object = PersistenceToolkit.createWorkingCopy((Object)object);
        this.m_strings = LocalizationModel.createLocalizationList(this.m_object);
        this.m_duplicateKeys = this.createDuplicates(this.m_strings);
    }

    private Set<String> createDuplicates(List<LocalizedString> m_strings2) {
        HashSet<String> duplicates = new HashSet<String>();
        HashSet<String> keys = new HashSet<String>();
        for (LocalizedString ls : this.m_strings) {
            if (keys.contains(ls.getKey())) {
                duplicates.add(ls.getKey());
            }
            keys.add(ls.getKey());
        }
        return duplicates;
    }

    public String[] getAlllocales() {
        return this.m_allLocales;
    }

    public void save() {
        PersistenceToolkit.commit((Object)this.m_object);
    }

    public Collection<String> getDuplicateKeys() {
        return this.m_duplicateKeys;
    }

    public List<LocalizedString> getStrings() {
        return this.m_strings;
    }

    public List<String> getUsedLocales() {
        if (this.m_usedLocales == null) {
            this.m_usedLocales = this.findUsedLocales();
        }
        return this.m_usedLocales;
    }

    public List<String> findUsedLocales() {
        TreeSet<String> localeSet = new TreeSet<String>();
        for (LocalizedString ls : this.m_strings) {
            for (String locale : ls.getLocales()) {
                localeSet.add(locale);
            }
        }
        if (localeSet.contains("default")) {
            localeSet.remove("default");
            localeSet.add("");
        }
        return this.sortLocales(localeSet);
    }

    private List<String> sortLocales(Set<String> localeSet) {
        ArrayList<String> list = new ArrayList<String>(localeSet);
        Collections.sort(list);
        return list;
    }

    public void export(String locale, File file) throws IOException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            for (LocalizedString ls : this.getStrings()) {
                String s = ls.getTextInLocale(locale);
                if (s == null || (s = s.trim()).length() <= 0) continue;
                printWriter.println(this.formatComment(ls));
                printWriter.println(this.formatKeyValuePair(ls, s));
                printWriter.println();
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            this.safeClose(file, printWriter);
            throw throwable;
        }
        this.safeClose(file, printWriter);
    }

    private String formatKeyValuePair(LocalizedString ls, String s) {
        return String.valueOf(ls.getKey()) + "=" + s;
    }

    private String formatComment(LocalizedString ls) {
        return "# " + ls.getPlacementDescription();
    }

    public void importForLocale(File file, String locale) throws IOException {
        Properties props = this.loadPropertiesFromFile(file);
        for (LocalizedString ls : this.getStrings()) {
            String key = ls.getKey();
            if (!props.containsKey(key)) continue;
            String text = (String)props.get(key);
            ls.setTextForLocale(locale, text);
            this.m_usedLocales = null;
            this.setChanged();
        }
        this.notifyObservers();
    }

    private Properties loadPropertiesFromFile(File file) throws IOException {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            properties.load(fis);
        }
        finally {
            this.safeClose(file, fis);
        }
        return properties;
    }

    private void safeClose(File file, Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                ComponentsPlugin.getDefault().getLogger().log(Level.WARNING, "Could not close file " + file);
            }
        }
    }

    public static List<LocalizedString> createLocalizationList(Object object) {
        Setting setting = PersistenceToolkit.getSetting((Object)object);
        ArrayList<LocalizedString> strings = new ArrayList<LocalizedString>();
        LocalizationModel.fillLocalizationList(setting, strings);
        return strings;
    }

    private static void fillLocalizationList(Setting setting, List<LocalizedString> strings) {
        Setting[] settings;
        Setting[] settingArray = settings = setting.getChildren().toArray(new Setting[0]);
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            Setting s = settingArray[n2];
            if (LocalizedString.isLocalizedString((Setting)s)) {
                strings.add((LocalizedString)setting.getChildObject(s.getName(), LocalizedString.class));
            } else {
                LocalizationModel.fillLocalizationList(s, strings);
            }
            ++n2;
        }
    }

    private String[] createAllLocales() {
        ArrayList<String> locales = new ArrayList<String>();
        Locale[] localeArray = SimpleDateFormat.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            locales.add(locale.toString());
            ++n2;
        }
        Collections.sort(locales);
        locales.add(0, "default");
        return locales.toArray(new String[locales.size()]);
    }

    public void generateNewKey(LocalizedString ls) {
        ls.generateNewKey();
        this.setChanged();
    }

    public void clearText(LocalizedString localizedString) {
        for (String locale : localizedString.getLocales()) {
            localizedString.setTextForLocale(locale, "");
        }
        this.setChanged();
    }
}

