/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.l10n;

import com.jrockit.mc.common.persistence.LocalizedString;
import com.jrockit.mc.components.ui.l10n.LocalizationModel;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.core.model.fields.BooleanField;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.StringField;
import com.jrockit.mc.core.ui.fields.AbstractFieldTableContentProvider;

final class LocalizarionStringProvider
extends AbstractFieldTableContentProvider {
    static int FIELD_COUNT = 0;
    public static final Field FIELD_KEY = new StringField(FIELD_COUNT++);
    public static final Field FIELD_PLACEMENT = new StringField(FIELD_COUNT++);
    public static final Field FIELD_DUPLICATE = new BooleanField(FIELD_COUNT++);
    private String[] m_usedLocales;
    private LocalizationModel m_model;

    static {
        FIELD_KEY.setName(Messages.LOCALIZATION_KEY_COLUMN_TEXT);
        FIELD_KEY.setMinWidth(85);
        FIELD_KEY.setWidthWeight(85);
        FIELD_PLACEMENT.setName(Messages.LOCALIZATION_LOCATION_COLUMN_TEXT);
        FIELD_PLACEMENT.setMinWidth(250);
        FIELD_PLACEMENT.setWidthWeight(250);
        FIELD_DUPLICATE.setName(Messages.LOCALIZATION_COLUMN_DUPLICATE_TEXT);
        FIELD_DUPLICATE.setMinWidth(50);
        FIELD_DUPLICATE.setWidthWeight(50);
    }

    LocalizarionStringProvider() {
    }

    public Object[] getColumnObject(Object inputRowElement) {
        if (inputRowElement instanceof LocalizedString) {
            LocalizedString ls = (LocalizedString)inputRowElement;
            Object[] result = new Object[this.m_usedLocales.length + FIELD_COUNT];
            result[LocalizarionStringProvider.FIELD_KEY.INDEX] = ls.getKey();
            result[LocalizarionStringProvider.FIELD_DUPLICATE.INDEX] = this.m_model.getDuplicateKeys().contains(ls.getKey());
            result[LocalizarionStringProvider.FIELD_PLACEMENT.INDEX] = ls.getPlacementDescription();
            int n = 0;
            while (n < this.m_usedLocales.length) {
                result[LocalizarionStringProvider.FIELD_COUNT + n] = ls.getTextInLocale(this.m_usedLocales[n]);
                ++n;
            }
            return result;
        }
        return EMPTY_OBJECT_ARRAY;
    }

    public Object[] getRowElements(Object input) {
        if (input instanceof LocalizationModel) {
            this.m_model = (LocalizationModel)input;
            this.m_usedLocales = this.m_model.getUsedLocales().toArray(new String[0]);
            return this.m_model.getStrings().toArray();
        }
        return EMPTY_OBJECT_ARRAY;
    }
}

