/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.toolbar;

import com.jrockit.mc.components.ui.contributions.UserInterfaceContribution;
import com.jrockit.mc.components.ui.tab.BaseDescriptor;
import com.jrockit.mc.components.ui.tab.ImageConverter;
import com.jrockit.mc.core.CorePlugin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public final class TabPageLabelProvider
extends LabelProvider {
    private final Map<Object, Image> m_imageCache = new HashMap<Object, Image>();
    private final Device m_device;

    public TabPageLabelProvider(Device device) {
        this.m_device = device;
    }

    public Image getImage(Object element) {
        if (element instanceof UserInterfaceContribution) {
            return this.createEditorImage((UserInterfaceContribution)element);
        }
        if (element instanceof BaseDescriptor) {
            return this.createBaseDescriptorImage((BaseDescriptor)element);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof UserInterfaceContribution) {
            return ((UserInterfaceContribution)element).getName();
        }
        if (element instanceof BaseDescriptor) {
            return ((BaseDescriptor)element).getName();
        }
        return null;
    }

    private Image createBaseDescriptorImage(BaseDescriptor base) {
        Image image = this.m_imageCache.get(base);
        if (image == null) {
            image = ImageConverter.createImage(this.m_device, base.getIcon());
            if (image == null) {
                image = base.createDefaultIcon(this.m_device);
            }
            this.m_imageCache.put(base, image);
        }
        return image;
    }

    private Image createEditorImage(UserInterfaceContribution uiContribution) {
        ImageDescriptor id;
        if (uiContribution.isOpen()) {
            return CorePlugin.getDefault().getImage("error_obj.gif");
        }
        Image image = this.m_imageCache.get(uiContribution.getContainerIdentifier());
        if (image == null && (id = uiContribution.getContainerImageDescriptor()) != null) {
            image = id.createImage();
            this.m_imageCache.put(uiContribution.getContainerIdentifier(), image);
        }
        return image;
    }

    public void dispose() {
        this.clear();
    }

    public void clear() {
        Object[] objectArray = this.m_imageCache.values().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object imageObject = objectArray[n2];
            ((Image)imageObject).dispose();
            ++n2;
        }
        this.m_imageCache.clear();
    }
}

