/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.toolbar;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.tab.TabItemDescriptor;
import java.util.Properties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PluginPropertiesDialog
extends TitleAreaDialog {
    public static final String PROPERTY_KEY_BUNDLE_ID = "bundle_id";
    public static final String PROPERTY_KEY_BUNDLE_VERSION = "bundle_version";
    private static String bundleID = "";
    private static String bundleVersion = "1.0.0";
    private Text bundleIDText;
    private Text bundleVersionText;

    public PluginPropertiesDialog(Shell parentShell, Object[] selected) {
        super(parentShell);
        this.setTitleImage(ComponentsPlugin.getDefault().getImage("exp_deployplug_wiz.png"));
        this.setupDefaults(selected);
    }

    private void setupDefaults(Object[] selected) {
        bundleVersion = "1.0.0";
        if (selected.length > 0 && selected[0] instanceof TabItemDescriptor) {
            TabItemDescriptor tid = (TabItemDescriptor)selected[0];
            bundleID = "com.jrockit.mc.flightrecorder.ext." + tid.getName().toLowerCase().replace(' ', '_');
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getShell().setText("Export Plug-in");
        this.setTitle("Export Plug-in");
        this.setMessage("Configure the plug-in properties");
        this.setTitleImage(ComponentsPlugin.getDefault().getImage("exp_deployplug_wiz.png"));
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = parent;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalIndent = 8;
        Label label = new Label(composite, 0);
        label.setText("Enter the plug-in id:");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.bundleIDText = new Text(composite, 2048);
        this.bundleIDText.setText(bundleID);
        this.bundleIDText.setLayoutData((Object)gd);
        gd = new GridData();
        label = new Label(composite, 0);
        label.setText("Enter the plug-in version:");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.bundleVersionText = new Text(composite, 2048);
        this.bundleVersionText.setText(bundleVersion);
        this.bundleVersionText.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void okPressed() {
        try {
            bundleID = this.bundleIDText.getText();
            bundleVersion = this.bundleVersionText.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.okPressed();
    }

    public Properties getPluginProperties() {
        Properties p = new Properties();
        p.put(PROPERTY_KEY_BUNDLE_ID, bundleID);
        p.put(PROPERTY_KEY_BUNDLE_VERSION, bundleVersion);
        return p;
    }
}

