/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.layout;

import com.jrockit.mc.components.ui.design.view.layout.SliderChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;

final class SliderControl
extends Composite {
    private final int MAX_SLIDER_STEPS = 100;
    private final ListenerList m_list = new ListenerList();
    private Label m_label;
    private Scale m_scale;
    private Text m_textInput;
    private double[] m_selectableValues = new double[]{1.0};

    public SliderControl(Composite parent) {
        super(parent, 0);
        this.createContents(this);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 2;
        layout.marginHeight = 0;
        this.setMinMax(0.0, 1000.0);
        this.setLayout((Layout)layout);
    }

    private void createContents(Composite parent) {
        GridData gd1 = new GridData(4, 0x1000000, false, false);
        this.m_label = new Label(parent, 0);
        this.m_label.setEnabled(false);
        this.m_label.setLayoutData((Object)gd1);
        GridData gd3 = new GridData(4, 4, false, false);
        this.m_textInput = new Text(parent, 2120);
        this.m_textInput.setEnabled(false);
        this.m_textInput.setLayoutData((Object)gd3);
        GridData gd2 = new GridData(4, 4, false, false);
        gd2.horizontalSpan = 2;
        gd2.widthHint = 100;
        this.m_scale = this.createSlider(parent);
        this.m_scale.setLayoutData((Object)gd2);
        GridData gd4 = new GridData(4, 0x1000000, true, false);
        gd4.horizontalSpan = 2;
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)gd4);
    }

    private Scale createSlider(Composite parent) {
        Scale slider = new Scale(parent, 256);
        slider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SliderControl.this.m_textInput.setText(Double.toString(SliderControl.this.getSliderValue()));
                SliderControl.this.notifyListener();
            }
        });
        slider.setMinimum(0);
        slider.setMaximum(this.m_selectableValues.length - 1);
        slider.setSelection(0);
        slider.setEnabled(false);
        return slider;
    }

    private void notifyListener() {
        Object[] listners = this.m_list.getListeners();
        int n = 0;
        while (n < listners.length) {
            ((SliderChangeListener)listners[n]).onChange(this.getSliderValue());
            ++n;
        }
    }

    private double getSliderValue() {
        return this.m_selectableValues[this.m_scale.getSelection()];
    }

    public void addChangeListener(SliderChangeListener changeListener) {
        this.m_list.add((Object)changeListener);
    }

    public void setText(String text) {
        this.m_label.setText(text);
        this.layout();
    }

    public void setValues(double ... selectableValuesvalues) {
        this.m_selectableValues = selectableValuesvalues;
        this.m_scale.setMinimum(0);
        this.m_scale.setMaximum(selectableValuesvalues.length - 1);
    }

    public void setMinMax(double min, double max) {
        double[] selectableValues = new double[101];
        int n = 0;
        while (n < 100) {
            selectableValues[n] = (double)n * (max - min) / 100.0;
            ++n;
        }
        this.setValues(selectableValues);
    }

    public void setValue(double value) {
        if (!this.m_scale.isEnabled()) {
            this.m_label.setEnabled(true);
            this.m_textInput.setEnabled(true);
            this.m_scale.setEnabled(true);
        }
        int sliderIndex = this.findClosestSliderIndex(value);
        this.m_scale.setSelection(sliderIndex);
        this.m_textInput.setText(Double.toString(this.m_selectableValues[sliderIndex]));
        this.notifyListener();
    }

    private int findClosestSliderIndex(double value) {
        int n = 0;
        while (n < this.m_selectableValues.length - 1) {
            if (value <= this.m_selectableValues[n]) {
                return n;
            }
            ++n;
        }
        return this.m_selectableValues.length - 1;
    }
}

