/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.layout;

import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.view.layout.LayoutSubPart;
import com.jrockit.mc.components.ui.design.view.layout.SliderChangeListener;
import com.jrockit.mc.components.ui.design.view.layout.SliderControl;
import com.jrockit.mc.core.layout.SimpleLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

final class SizePart
extends LayoutSubPart {
    private SliderControl m_maxSizeControl;
    private SliderControl m_minSizeControl;
    private SliderControl m_weightControl;

    SizePart() {
    }

    protected Control createPart(Composite parent) {
        GridLayout layout = new GridLayout();
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, true, false);
        this.m_minSizeControl = this.createMinControl(container);
        this.m_minSizeControl.setLayoutData(gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        this.m_maxSizeControl = this.createMaxControl(container);
        this.m_maxSizeControl.setLayoutData(gd2);
        GridData gd4 = new GridData(4, 4, true, false);
        this.m_weightControl = this.createWeightControl(container);
        this.m_weightControl.setLayoutData(gd4);
        return container;
    }

    private SliderControl createWeightControl(Composite container) {
        SliderControl control = new SliderControl(container);
        control.addChangeListener(new SliderChangeListener(){

            public void onChange(double value) {
                LayoutItem item = SizePart.this.getActiveItem();
                if (item != null) {
                    item.setWeight((float)value);
                    item.notifyObservers();
                }
            }
        });
        control.setText("Weight:");
        control.setValues(this.createWeightValues());
        return control;
    }

    private double[] createWeightValues() {
        double[] values = new double[10];
        int n = 0;
        while (n < values.length) {
            values[n] = 1 + n;
            ++n;
        }
        return values;
    }

    private SliderControl createMaxControl(Composite container) {
        SliderControl control = new SliderControl(container);
        control.addChangeListener(new SliderChangeListener(){

            public void onChange(double value) {
                LayoutItem item = SizePart.this.getActiveItem();
                if (item != null) {
                    if (Double.isInfinite(value)) {
                        item.setMaxSize(SimpleLayout.INFINITE_SIZE);
                    } else {
                        item.setMaxSize((int)value);
                    }
                    item.notifyObservers();
                }
            }
        });
        control.setText("Maximum:");
        control.setValues(this.createSizeValues(true));
        return control;
    }

    double[] createSizeValues(boolean allowInfinity) {
        double[] values = new double[100];
        int index = 0;
        int n = 0;
        while (n <= 200) {
            values[index++] = n;
            n += 5;
        }
        n = 210;
        while (n <= 500) {
            values[index++] = n;
            n += 10;
        }
        n = 520;
        while (n <= 800) {
            values[index++] = n;
            n += 20;
        }
        while (index < values.length) {
            values[index] = values[index - 1] + 50.0;
            ++index;
        }
        if (allowInfinity) {
            values[values.length - 1] = Double.POSITIVE_INFINITY;
        }
        return values;
    }

    private SliderControl createMinControl(Composite container) {
        SliderControl control = new SliderControl(container);
        control.addChangeListener(new SliderChangeListener(){

            public void onChange(double value) {
                LayoutItem item = SizePart.this.getActiveItem();
                if (item != null) {
                    if (Double.isInfinite(value)) {
                        item.setMinSize(SimpleLayout.INFINITE_SIZE);
                    } else {
                        item.setMinSize((int)value);
                    }
                    item.notifyObservers();
                }
            }
        });
        control.setText("Minimum:");
        control.setValues(this.createSizeValues(false));
        return control;
    }

    protected void update() {
        this.m_maxSizeControl.setValue(this.getSizeValue(this.getActiveItem().getMaximumSize()));
        this.m_minSizeControl.setValue(this.getSizeValue(this.getActiveItem().getMinimumSize()));
        this.m_weightControl.setValue(this.getWeightValue(this.getActiveItem().getWeight()));
    }

    private double getWeightValue(float weight) {
        if (weight == Float.MAX_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        return weight;
    }

    private double getSizeValue(int size) {
        if (size == Integer.MAX_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        return size;
    }
}

