/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.layout;

import com.jrockit.mc.components.ui.design.view.layout.LayoutSubPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

final class OrientationPart
extends LayoutSubPart {
    private Button m_horizontalButton;
    private Button m_verticalButton;
    private Composite m_container;

    OrientationPart() {
    }

    protected void update() {
        this.m_horizontalButton.setVisible(this.getActiveItem().getChildren().size() > 1);
        this.m_verticalButton.setVisible(this.getActiveItem().getChildren().size() > 1);
        this.m_horizontalButton.setEnabled(true);
        this.m_verticalButton.setEnabled(true);
        this.m_horizontalButton.setSelection(this.getActiveItem().getLayout().getHorizontalOrientation());
        this.m_verticalButton.setSelection(!this.getActiveItem().getLayout().getHorizontalOrientation());
        this.m_container.layout();
    }

    protected Control createPart(Composite parent) {
        this.m_container = new Composite(parent, 0);
        this.m_container.setLayout((Layout)new GridLayout(2, false));
        GridData gd1 = new GridData(4, 4, true, true);
        this.m_horizontalButton = this.createButton(this.m_container, true);
        this.m_horizontalButton.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        this.m_verticalButton = this.createButton(this.m_container, false);
        this.m_verticalButton.setLayoutData((Object)gd2);
        return this.m_container;
    }

    private Button createButton(Composite parent, final boolean horizontalState) {
        Button button = new Button(parent, 16);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrientationPart.this.setLayout(horizontalState);
            }
        });
        button.setEnabled(false);
        if (horizontalState) {
            button.setText("Horizontal");
        } else {
            button.setText("Vertical");
        }
        return button;
    }

    private void setLayout(boolean orientation) {
        if (this.getActiveItem() != null) {
            this.getActiveItem().setHorizontal(orientation);
            this.getActiveItem().notifyObservers();
        }
    }
}

