/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.layout;

import com.jrockit.mc.components.ui.design.actions.DesignModeAction;
import com.jrockit.mc.components.ui.design.view.layout.LayoutSubPart;
import com.jrockit.mc.components.ui.design.view.layout.LayoutViewSelectionListener;
import com.jrockit.mc.components.ui.design.view.layout.OrientationPart;
import com.jrockit.mc.components.ui.design.view.layout.PadComponentsPart;
import com.jrockit.mc.components.ui.design.view.layout.SizePart;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.CorePlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutPage
extends Page
implements IPageBookViewPage {
    private final LayoutViewSelectionListener m_layoutSelectionListener = new LayoutViewSelectionListener(this);
    private final List<LayoutSubPart> m_parts = new ArrayList<LayoutSubPart>();
    private final IServiceLocator m_serviceLocator;
    private Composite m_container;

    public LayoutPage(IServiceLocator serviceLocator) {
        this.m_serviceLocator = serviceLocator;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.getSite().getActionBars().getToolBarManager().add((IAction)new DesignModeAction(this.m_serviceLocator));
    }

    public void createControl(Composite parent) {
        this.m_container = new Composite(parent, 0);
        Label text = new Label(this.m_container, 0x1000000);
        text.setText(Messages.LAYOUT_SETTINGS_TITLE);
        text.setLayoutData((Object)this.createLayoutData());
        this.addPart(this.m_container, new SizePart());
        this.addPart(this.m_container, new OrientationPart());
        this.addPart(this.m_container, new PadComponentsPart());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginBottom = 0;
        this.m_container.setLayout((Layout)layout);
        this.initializeSelectionListener();
    }

    private void addPart(Composite container, LayoutSubPart layoutPart) {
        Control control = layoutPart.create(container);
        control.setLayoutData((Object)this.createLayoutData());
        this.m_parts.add(layoutPart);
    }

    public void setServiceLocator(IServiceLocator locator) {
        for (LayoutSubPart subba : this.m_parts) {
            subba.setServiceLocator(locator);
        }
    }

    private GridData createLayoutData() {
        return new GridData(4, 4, true, false);
    }

    public List<LayoutSubPart> getParts() {
        return this.m_parts;
    }

    public Control getControl() {
        return this.m_container;
    }

    private ISelectionService getSelectionService() {
        return this.getSite().getWorkbenchWindow().getSelectionService();
    }

    private void initializeSelectionListener() {
        this.getSelectionService().addSelectionListener((ISelectionListener)this.m_layoutSelectionListener);
    }

    private void clearSelectionListener() {
        if (this.m_layoutSelectionListener != null) {
            this.getSelectionService().removeSelectionListener((ISelectionListener)this.m_layoutSelectionListener);
        }
    }

    public Image getImage() {
        return CorePlugin.getDefault().getImage("layout.gif");
    }

    public void dispose() {
        super.dispose();
        for (LayoutSubPart part : this.getParts()) {
            part.dispose();
        }
        this.clearSelectionListener();
    }

    public void setFocus() {
        if (!this.getParts().isEmpty()) {
            this.getParts().get(0).setFocus();
        }
    }
}

