/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.components;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.behaviors.IConfigurer;
import com.jrockit.mc.components.ui.behaviors.IStatusListener;
import com.jrockit.mc.components.ui.behaviors.IStatusProvider;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeRegistry;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.InputPanel;
import com.jrockit.mc.components.ui.settings.LocalizedStringInput;
import com.jrockit.mc.components.ui.settings.StatusWizardPage;
import com.jrockit.mc.components.ui.settings.StringInput;
import com.jrockit.mc.components.ui.util.Dynamic;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.core.wizards.IPerformFinishable;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;

public final class ComponentDescriptorWizardPage
extends StatusWizardPage
implements IPerformFinishable {
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String IDENTIFIER = "identifier";
    private static final int DIALOG_MAX_WIDTH = Integer.MAX_VALUE;
    private static final int DIALOG_MIN_WIDTH = 600;
    private final boolean m_showIdentifier;
    private final IConfigurer m_configurer;
    private final IServiceLocator m_serviceLocator;

    public ComponentDescriptorWizardPage(IConfigurer configurer, IServiceLocator locator, ComponentDescriptor componentDescriptor, boolean showIdentifier) {
        super(componentDescriptor);
        this.m_serviceLocator = locator;
        this.m_showIdentifier = showIdentifier;
        this.m_configurer = configurer;
    }

    public static ComponentDescriptor openNew(IServiceLocator serviceLocator, ComponentTypeDescriptor type) {
        ComponentDescriptor cd = ComponentDescriptor.createNew(type);
        if (type.hasConfigurer()) {
            return ComponentDescriptorWizardPage.editExisting(serviceLocator, cd, true) ? cd : null;
        }
        return cd;
    }

    public static boolean editExisting(IServiceLocator serviceLocator, ComponentDescriptor cd, boolean showIdentifier) {
        ComponentTypeRegistry ctr = ComponentsPlugin.getDefault().getComponentTypeRegistry();
        IConfigurer configurer = ctr.createConfigurer(cd);
        ComponentDescriptorWizardPage cw = new ComponentDescriptorWizardPage(configurer, serviceLocator, cd, showIdentifier);
        IWorkbenchWindow window = (IWorkbenchWindow)serviceLocator.getService("workbenchWindow");
        OnePageWizardDialog owd = new OnePageWizardDialog(window.getShell(), (IWizardPage)cw);
        owd.setWidthConstaint(600, Integer.MAX_VALUE);
        owd.setWidthConstaint(400, 800);
        owd.setHeightConstraint(300, Integer.MAX_VALUE);
        ComponentTypeDescriptor ctDescriptor = ctr.getComponentTypeDescriptor(cd.getTypeIdentifier());
        owd.setImage(ctDescriptor.getIcon());
        return owd.open() == 0;
    }

    public Composite createControlArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        GridData gd1 = new GridData(4, 4, true, false);
        Control standardInputControl = this.createStandard(container);
        standardInputControl.setLayoutData((Object)gd1);
        if (this.m_configurer != null) {
            GridData gd2 = new GridData(4, 4, true, true);
            Control configurationControl = this.createConfigurer(container);
            configurationControl.setLayoutData((Object)gd2);
        }
        return container;
    }

    public boolean performFinish() {
        if (super.performFinish()) {
            this.unHookConfigurerListener();
            return true;
        }
        return false;
    }

    protected String createTitle() {
        return String.valueOf(Messages.COMPONENT_DESCRIPTOR_WIZARD_PROPERTIES_FOR_COMPONENT_TEXT) + this.getComponentDescriptor().getName();
    }

    protected void hookConfigurerStatusProvider() {
        IStatusProvider provider = Dynamic.cast(this.m_configurer, IStatusProvider.class);
        if (provider != null) {
            this.getStatusProvider().addStatusProvider(provider);
        }
    }

    private void unHookConfigurerListener() {
        IStatusProvider provider = Dynamic.cast(this.m_configurer, IStatusProvider.class);
        if (provider != null) {
            provider.removeStatusListener(this.getStatusLIstener());
        }
    }

    private void hookNameListener(IInput name) {
        name.addStatusListener(new IStatusListener(){

            public void onChange(IStatus status) {
                ComponentDescriptorWizardPage.this.updateTitle();
            }
        });
    }

    private Control createConfigurer(Composite container) {
        this.m_configurer.initialize(this.getComponentDescriptor());
        this.m_configurer.initialize(this.m_serviceLocator);
        Control control = this.m_configurer.createPart(container);
        this.hookConfigurerStatusProvider();
        return control;
    }

    private ComponentDescriptor getComponentDescriptor() {
        return (ComponentDescriptor)this.getConfigurationObject();
    }

    private Control createStandard(Composite parent) {
        ArrayList<IInput> inputs = new ArrayList<IInput>();
        if (this.m_showIdentifier) {
            inputs.add(new StringInput(IDENTIFIER, Messages.COMPONENT_DESCRIPTOR_WIZARD_IDENTIFIER_INPUT_TEXT).setAllowSpace(false).setAllowEmpty(false));
        }
        inputs.add(this.createName());
        inputs.add(new LocalizedStringInput(DESCRIPTION, Messages.COMPONENT_DESCRIPTOR_WIZARD_DESCRIPTION_INPUT_TEXT));
        InputPanel panel = new InputPanel(parent, this.getConfigurationObject(), inputs);
        this.getStatusProvider().addStatusProvider(panel);
        return panel.getControl();
    }

    private IInput createName() {
        LocalizedStringInput name = new LocalizedStringInput(NAME, Messages.COMPONENT_DESCRIPTOR_WIZARD_NAME_INPUT_TEXT);
        this.hookNameListener(name);
        return name;
    }
}

