/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.tabfolder;

import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptor;
import com.jrockit.mc.components.ui.design.tabfolder.TabFolderItemContentProvider;
import com.jrockit.mc.components.ui.design.tabfolder.TabFolderItemDescriptor;
import com.jrockit.mc.components.ui.design.tabfolder.TabFolderItemRepository;
import com.jrockit.mc.components.ui.design.view.components.ComponentTypeWizardPage;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.ComponentDescriptorInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.IMasterDetailFactory;
import com.jrockit.mc.components.ui.settings.LocalizedStringInput;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.FieldTableViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TabPageMasterDetailFactory
implements IMasterDetailFactory {
    private final Field[] FIELD_PROTOTYPES = new Field[]{TabFolderItemContentProvider.FIELD_NAME};
    private final TabFolderItemRepository m_tabFolderItemRepository;
    private final IServiceLocator m_serviceLocator;

    TabPageMasterDetailFactory(TabFolderItemRepository tabFolderItemRepository, IServiceLocator serviceLocator) {
        this.m_tabFolderItemRepository = tabFolderItemRepository;
        this.m_serviceLocator = serviceLocator;
    }

    @Override
    public IInput createDetailBaseInput(Shell shell) {
        return null;
    }

    @Override
    public List<IInput> createDetailInput() {
        ArrayList<IInput> list = new ArrayList<IInput>();
        list.add(new LocalizedStringInput("title", Messages.TAB_FOLDER_COMPONENT_CONFIGURATION_TITLE_INPUT_TEXT));
        list.add(new ComponentDescriptorInput(this.m_serviceLocator, "componentDescriptor", Messages.TAB_FOLDER_COMPONENT_CONFIGURATION_COMPONENT_INPUT_TEXT));
        return list;
    }

    public List createDetailList() {
        return this.m_tabFolderItemRepository.getTabFolderItems();
    }

    @Override
    public List<IInput> createMainInputs() {
        return new ArrayList<IInput>();
    }

    @Override
    public String createMasterTableTitle() {
        return Messages.TAB_FOLDER_MASTER_TABLE_TITLE;
    }

    @Override
    public List<Object> createNew(Shell shell) {
        ComponentDescriptor cd;
        ComponentTypeWizardPage ctwp = new ComponentTypeWizardPage();
        OnePageWizardDialog owd = new OnePageWizardDialog(shell, (IWizardPage)ctwp);
        owd.setWidthConstaint(400, 700);
        owd.setHeightConstraint(300, Integer.MAX_VALUE);
        owd.open();
        ComponentTypeDescriptor ctd = ctwp.getSelected();
        if (ctd != null && (cd = ComponentDescriptor.createNew(ctd)) != null) {
            TabFolderItemDescriptor tid = new TabFolderItemDescriptor();
            tid.setTitle(cd.getName());
            tid.setComponentDescriptor(cd);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(tid);
            return list;
        }
        return null;
    }

    @Override
    public StructuredViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 268503812);
        FieldTableViewer tableViewer = new FieldTableViewer(table, this.FIELD_PROTOTYPES);
        tableViewer.setContentProvider((IContentProvider)new TabFolderItemContentProvider());
        tableViewer.setInput(this.m_tabFolderItemRepository.getTabFolderItems());
        return tableViewer;
    }

    @Override
    public List<IInput> createSpecific() {
        return new ArrayList<IInput>();
    }

    @Override
    public String createSpecificTitle() {
        return null;
    }
}

