/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.tabfolder;

import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.components.ui.behaviors.IComponent;
import com.jrockit.mc.components.ui.behaviors.IComponentDescribable;
import com.jrockit.mc.components.ui.behaviors.ICreatePart;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.design.GUIFactory;
import com.jrockit.mc.components.ui.design.tabfolder.TabFolderItemDescriptor;
import com.jrockit.mc.components.ui.design.tabfolder.TabFolderItemRepository;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class TabFolderComponent
extends AbstractUIComponent
implements ICreatePart,
IComponent,
IComponentDescribable {
    public Control createPart(Composite parent) {
        CTabFolder tabFolder = new CTabFolder(parent, 0);
        this.addTabs(tabFolder);
        this.getFormToolkit().adapt((Composite)tabFolder);
        tabFolder.setSelection(0);
        return tabFolder;
    }

    private void addTabs(CTabFolder tabFolder) {
        GUIFactory factory = new GUIFactory(this.getServiceLocator());
        for (TabFolderItemDescriptor tfid : this.getTabFolderItemRepository().getTabFolderItems()) {
            ComponentDescriptor cd = tfid.getComponentDescriptor();
            if (cd == null) continue;
            Object component = factory.createComponent(cd);
            Composite control = (Composite)factory.createComponentControl((Composite)tabFolder, component);
            if (control != null) {
                CTabItem tabItem = new CTabItem(tabFolder, 0);
                tabItem.setControl((Control)control);
                tabItem.setText(tfid.getTitle());
                factory.addComponentToScope(component);
            }
            this.getFormToolkit().adapt(control);
        }
    }

    private TabFolderItemRepository getTabFolderItemRepository() {
        return (TabFolderItemRepository)this.getComponentSettings().getChildObject("tabFolderItemRepository", TabFolderItemRepository.class);
    }
}

