/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.menus;

import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.actions.AddLayoutItemAction;
import com.jrockit.mc.components.ui.design.actions.CollapseLayoutItem;
import com.jrockit.mc.components.ui.design.actions.ComponentPropertiesAction;
import com.jrockit.mc.components.ui.design.actions.DeleteComponentAction;
import com.jrockit.mc.components.ui.design.actions.ExportAction;
import com.jrockit.mc.components.ui.design.actions.ImportAction;
import com.jrockit.mc.components.ui.design.actions.SpliType;
import com.jrockit.mc.components.ui.design.actions.SplitAction;
import com.jrockit.mc.components.ui.design.menus.AssignComponentMenu;
import com.jrockit.mc.components.ui.design.menus.BaseMenu;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public final class DesignMenu
extends BaseMenu {
    public DesignMenu(LayoutItem item, IServiceLocator locator) {
        super(Messages.DESIGN_MENU_DESIGN_MENU_TEXT, item, locator);
    }

    protected void populateMenu(IMenuManager manager) {
        if (this.isNotComposite()) {
            this.addAssignCompomentMenu(manager);
        }
        this.addLayoutItems(manager);
        if (this.isNotComposite()) {
            this.addImportExport(manager);
            if (this.hasComponentDescriptor()) {
                this.addProperties(manager);
            }
        }
    }

    private void addImportExport(IMenuManager manager) {
        this.addImport(manager);
        if (this.hasComponentDescriptor()) {
            this.addExport(manager);
        }
        this.addSeparator(manager);
    }

    private void addExport(IMenuManager manager) {
        ComponentDescriptor cd = this.getLayoutItem().getComponentDescriptor();
        manager.add((IAction)new ExportAction(this.getShell(), Messages.DESIGN_MENU_DESIGN_MENU_EXPORT_COMPONENT_TEXT, String.valueOf(cd.getIdentifier()) + ".xml", cd));
    }

    private Shell getShell() {
        return ((IWorkbenchWindow)this.getServiceLocator().getService("workbenchWindow")).getShell();
    }

    private void addImport(IMenuManager manager) {
        ComponentDescriptor cd = this.hasComponentDescriptor() ? this.getLayoutItem().getComponentDescriptor() : new ComponentDescriptor();
        ImportAction<ComponentDescriptor> ia = new ImportAction<ComponentDescriptor>(this.getShell(), Messages.DESIGN_MENU_DESIGN_MENU_IMPORT_COMPONENT_TEXT, cd){

            @Override
            protected void commitObject(ComponentDescriptor cd) {
                DesignMenu.this.getLayoutItem().setComponentDescripor(cd);
                DesignMenu.this.getLayoutItem().notifyObservers();
            }
        };
        manager.add((IAction)ia);
    }

    private void addLayoutItems(IMenuManager manager) {
        if (!this.hasComponentDescriptor()) {
            this.addSplit(manager);
        }
        this.addAdd(manager);
        this.addCollapse(manager);
        this.addSeparator(manager);
    }

    private void addSeparator(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
    }

    private void addCollapse(IMenuManager manager) {
        if (this.hasParent()) {
            manager.add((IAction)new CollapseLayoutItem(this.getLayoutItem()));
        }
    }

    private void addProperties(IMenuManager manager) {
        manager.add((IAction)new ComponentPropertiesAction(this.getServiceLocator(), this.getLayoutItem(), true));
    }

    private void addAssignCompomentMenu(IMenuManager manager) {
        manager.add((IContributionItem)new AssignComponentMenu(this.getLayoutItem(), this.getServiceLocator()));
        if (this.hasComponentDescriptor()) {
            manager.add((IAction)new DeleteComponentAction(this.getLayoutItem()));
        }
        this.addSeparator(manager);
    }

    private void addSplit(IMenuManager manager) {
        if (this.isNotComposite()) {
            manager.add((IAction)new SplitAction(SpliType.HORIZONTALLY, this.getLayoutItem()));
            manager.add((IAction)new SplitAction(SpliType.VERTICALLY, this.getLayoutItem()));
        }
    }

    private void addAdd(IMenuManager manager) {
        if (this.hasParent()) {
            if (!this.getLayoutItem().getParent().isHorizontal()) {
                manager.add((IAction)new AddLayoutItemAction(AddLayoutItemAction.POSITION.WEST, this.getLayoutItem()));
                manager.add((IAction)new AddLayoutItemAction(AddLayoutItemAction.POSITION.EAST, this.getLayoutItem()));
            } else {
                manager.add((IAction)new AddLayoutItemAction(AddLayoutItemAction.POSITION.NORTH, this.getLayoutItem()));
                manager.add((IAction)new AddLayoutItemAction(AddLayoutItemAction.POSITION.SOUTH, this.getLayoutItem()));
            }
        }
    }

    private boolean isNotComposite() {
        return this.getLayoutItem().getChildren().isEmpty();
    }

    private boolean hasParent() {
        return this.getLayoutItem().getParent() != null;
    }

    private boolean hasComponentDescriptor() {
        return this.getLayoutItem().getComponentDescriptor() != null;
    }
}

