/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.actions;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.design.actions.FileAction;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Shell;

public final class ExportAction
extends FileAction {
    private final Object m_exportObject;
    private final String m_fileName;

    public ExportAction(Shell shell, String title, String fileName, Object exportObject) {
        super(shell, 8192, title);
        this.setImageDescriptor(ComponentsPlugin.getDefault().getMCImageDescriptor("export.gif"));
        this.m_exportObject = exportObject;
        this.m_fileName = fileName;
    }

    protected final String createSuggestedFileName() {
        return this.m_fileName;
    }

    protected void fileOperation(Shell shell, String fileName) {
        File file = new File(fileName);
        try {
            PersistenceToolkit.exportObjectToFile((Object)this.m_exportObject, (File)file);
        }
        catch (IOException e) {
            this.showError(Messages.DESIGN_MENU_EXPORT_ACTION_ERROR_TITLE, String.valueOf(MessageFormat.format(Messages.DESIGN_MENU_EXPORT_ACTION_ERROR_TEXT, file)) + "\n" + e.getMessage());
        }
    }
}

