/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.actions;

import com.jrockit.mc.components.ui.design.DesignModel;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.CorePlugin;
import org.eclipse.jface.action.Action;

public final class DesignModeAction
extends Action {
    private IServiceLocator m_serviceLocator;

    public DesignModeAction(IServiceLocator serviceLocator) {
        super("Design Mode On/Off", 8);
        this.m_serviceLocator = serviceLocator;
        this.setToolTipText("Switch designer mode on and off");
        this.updateImage();
    }

    public void run() {
        DesignModel model = this.m_serviceLocator.getService(DesignModel.class);
        if (model != null) {
            model.setDesignerMode(!model.isDesignerModeOn());
            this.updateImage();
            model.notifyObservers();
        }
    }

    void updateImage() {
        if (this.m_serviceLocator != null) {
            DesignModel model = this.m_serviceLocator.getService(DesignModel.class);
            if (model != null) {
                this.updateImageDesignModeOn(model);
            }
        } else {
            this.updateImageDesignModeOff();
        }
    }

    private void updateImageDesignModeOff() {
        this.setEnabled(false);
        this.setImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("stop.gif"));
    }

    private void updateImageDesignModeOn(DesignModel model) {
        this.setEnabled(true);
        if (model.isDesignerModeOn()) {
            this.setImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("play.gif"));
        } else {
            this.setImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("stop.gif"));
        }
    }
}

