/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.LayoutItemCanvas;
import com.jrockit.mc.components.ui.design.menus.DesignMenu;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;

public final class LayoutItemClickListener
extends MouseAdapter {
    private final LayoutItem m_item;
    private final LayoutItemCanvas m_control;
    private final IServiceLocator m_serviceLocator;

    public LayoutItemClickListener(LayoutItemCanvas control, LayoutItem item, IServiceLocator locator) {
        this.m_item = item;
        this.m_control = control;
        this.m_serviceLocator = locator;
        this.m_control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    LayoutItemClickListener.this.onClickLeft();
                }
                if (e.button == 3) {
                    LayoutItemClickListener.this.onRightClick();
                }
            }
        });
    }

    protected final LayoutItem getLayoutItem() {
        return this.m_item;
    }

    private LayoutItem getActiveLayoutItem() {
        LayoutItem item = this.getLayoutItem();
        while (item != null) {
            if (this.m_control.isSelected()) {
                return item;
            }
            item = item.getParent();
        }
        return null;
    }

    private void onClickLeft() {
        LayoutItemCanvas parent = this.m_control.getParentToSelect();
        if (parent != null) {
            parent.setSelected();
        } else {
            this.m_control.setSelected();
        }
    }

    private void onRightClick() {
        if (!this.m_control.isSelected()) {
            this.m_control.setSelected();
        }
        if (this.getActiveLayoutItem() != null) {
            DesignMenu menuManager = new DesignMenu(this.getActiveLayoutItem(), this.m_serviceLocator);
            this.m_control.setMenu(menuManager.createContextMenu((Control)this.m_control));
        }
    }
}

