/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptor;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.LayoutItemClickListener;
import com.jrockit.mc.components.ui.design.SelectionContext;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.layout.SimpleLayout;
import com.jrockit.mc.core.site.IServiceRegistry;
import com.jrockit.mc.core.site.SectionSite;
import com.jrockit.mc.core.site.SiteFocusListener;
import com.jrockit.mc.core.ui.SelectionProvider;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.FormColors;

public final class LayoutItemCanvas
extends Canvas {
    private final LayoutItem m_layoutItem;
    private final IServiceLocator m_locator;
    private final SectionSite m_site;
    private final SelectionProvider m_selectionProvider;
    private LayoutItemCanvas m_layoutParent;
    private SelectionContext m_selectionContext;

    public LayoutItemCanvas(SelectionContext selectionContext, Composite parent, LayoutItem item, IServiceLocator locator) {
        super(parent, 0x20040000);
        this.m_layoutParent = parent instanceof LayoutItemCanvas ? (LayoutItemCanvas)parent : null;
        this.m_layoutItem = item;
        this.m_selectionContext = selectionContext;
        this.m_locator = locator;
        this.m_site = new SectionSite("layoutItem", (IWorkbenchPartSite)locator.getService("workbenchPartSite"), (IServiceRegistry)locator);
        this.m_selectionProvider = new SelectionProvider();
        this.m_site.setSelectionProvider((ISelectionProvider)this.m_selectionProvider);
        this.hookListeners();
    }

    LayoutItemCanvas getLayoutParent() {
        return this.m_layoutParent;
    }

    public LayoutItemCanvas getParentToSelect() {
        if (this.getLayoutParent() != null) {
            if (this.isSelected()) {
                return this.getLayoutParent();
            }
            return this.getLayoutParent().getParentToSelect();
        }
        return null;
    }

    private void hookListeners() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                LayoutItemCanvas.this.paint(e);
            }
        });
        new LayoutItemClickListener(this, this.m_layoutItem, this.m_locator);
        final Observer observer = new Observer(){

            public void update(Observable o, Object arg) {
                LayoutItemCanvas.this.redraw();
                LayoutItemCanvas.this.setRedraw(true);
            }
        };
        this.m_layoutItem.addObserver(observer);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LayoutItemCanvas.this.m_layoutItem.deleteObserver(observer);
            }
        });
        this.addFocusListener((FocusListener)new SiteFocusListener(this.m_site));
    }

    public void paint(PaintEvent e) {
        Display display = e.display;
        GC gc = e.gc;
        this.fillBackground(CorePlugin.getDefault().getFormColors(display), gc);
        this.setGcColors(gc);
        Rectangle client = this.createInset(this.getClientArea(), 10);
        gc.fillRectangle(client);
        gc.drawRectangle(client);
        if (this.getChildren().length == 0) {
            this.drawInfo(e.gc);
        }
    }

    private void fillBackground(FormColors colors, GC gc) {
        gc.setBackground(colors.getBackground());
        gc.setForeground(colors.getForeground());
        gc.fillRectangle(this.getClientArea());
    }

    private void setGcColors(GC gc) {
        if (this.isSelectedOrParent(this.m_layoutItem)) {
            gc.setBackground(this.getDisplay().getSystemColor(26));
            gc.setForeground(this.getDisplay().getSystemColor(25));
        } else {
            if (this.getChildren().length == 0) {
                gc.setBackground(this.getDisplay().getSystemColor(22));
            } else {
                gc.setBackground(this.getDisplay().getSystemColor(25));
            }
            gc.setForeground(this.getDisplay().getSystemColor(21));
        }
    }

    public boolean isSelected() {
        return this.m_selectionContext.getSelectedObject() == this.m_layoutItem;
    }

    private ISelectionProvider getProvider() {
        return this.m_selectionProvider;
    }

    public void setSelected() {
        this.forceFocus();
        this.getProvider().setSelection((ISelection)new StructuredSelection((Object)this.m_layoutItem));
        this.m_selectionContext.setSelectedObject(this.m_layoutItem);
    }

    private boolean isSelectedOrParent(LayoutItem item) {
        if (this.isSelected()) {
            return true;
        }
        return item.getParent() == null ? false : this.isSelectedOrParent(item.getParent());
    }

    private void drawInfo(GC gc) {
        this.drawText(gc, 0, this.formatLayoutProperties());
        ComponentDescriptor cd = this.m_layoutItem.getComponentDescriptor();
        this.drawText(gc, 2, "Name: " + (cd == null ? Messages.LAYOUT_ITEM_MISSING_COMPONENT_DESCRIPTOR_TEXT : cd.getName()));
        this.drawText(gc, 3, "Type: " + (cd == null ? Messages.LAYOUT_ITEM_MISSING_COMPONENT_DESCRIPTOR_TEXT : cd.getTypeIdentifier()));
        this.drawText(gc, 4, "Identifier: " + (cd == null ? Messages.LAYOUT_ITEM_MISSING_COMPONENT_DESCRIPTOR_TEXT : cd.getIdentifier()));
        if (cd != null) {
            this.drawIcon(gc, cd);
        }
    }

    private void drawIcon(GC gc, ComponentDescriptor cd) {
        ComponentTypeDescriptor ct = ComponentsPlugin.getDefault().getComponentTypeRegistry().getComponentTypeDescriptor(cd.getTypeIdentifier());
        if (ct != null && ct.getIcon() != null) {
            int width = this.getClientArea().width;
            int height = this.getClientArea().height;
            gc.drawImage(ct.getIcon(), 0, 0, 16, 16, width / 2 - 8, height / 2 - 8, 16, 16);
        }
    }

    private String formatLayoutProperties() {
        String result = "";
        result = String.valueOf(result) + Messages.LAYOUT_ITEM_MINIMUM_LAYOUT_SIZE_TEXT + this.formatLayoutSize(this.m_layoutItem.getMinimumSize()) + " ";
        result = String.valueOf(result) + Messages.LAYOUT_ITEM_MAXIMUM_LAYOUT_SIZE_TEXT + this.formatLayoutSize(this.m_layoutItem.getMaximumSize()) + " ";
        result = String.valueOf(result) + Messages.LAYOUT_ITEM_LAYOUT_WEIGHT_TEXT + this.m_layoutItem.getWeight() + " ";
        result = String.valueOf(result) + Messages.LAYOUT_ITEM_SIZE + this.getClientArea().width + "x" + this.getClientArea().height;
        return result;
    }

    private String formatLayoutSize(int size) {
        if (size == SimpleLayout.INFINITE_SIZE) {
            return "Infinity";
        }
        return Integer.toString(size);
    }

    private void drawText(GC gc, int row, String text) {
        int centerX = 5;
        int centerY = 5;
        gc.drawString(text, centerX, centerY + row * (gc.getFontMetrics().getHeight() + 5));
    }

    private Rectangle createInset(Rectangle rect, int inset) {
        Rectangle rectangle = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        --rectangle.width;
        --rectangle.height;
        return rectangle;
    }
}

